#ifndef MARS_MHPedestalCam
#define MARS_MHPedestalCam

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class MHPedestalPix;
class MPedestalCam;
class MHPedestalCam : public MH, public MCamEvent
{

private:

  TObjArray  *fArray;       //-> List of Lo/Hi gain Histograms

  MPedestalCam *fPedestals; //! need to initialize MPedestalCam to zero (which is not default!)
  
  Float_t fExtractSlices;
  
public:
  MHPedestalCam(const char *name=NULL, const char *title=NULL);
  ~MHPedestalCam();
  
  MHPedestalPix &operator[](UInt_t i);
  const MHPedestalPix &operator[](UInt_t i) const;
  
  Bool_t SetupFill(const MParList *pList);
  Bool_t Fill(const MParContainer *par, const Stat_t w=1);
  Bool_t Finalize();
  
  TObject *Clone(const char *) const;
  
  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;
  
  ClassDef(MHPedestalCam, 1)	// Storage Container for all pedestal information of the camera
};

#endif

