#ifndef MARS_MPedestalCam
#define MARS_MPedestalCam

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;

class MGeomCam;
class MPedestalPix;
class MPedestalCam : public MCamEvent, public MParContainer
{

private:

  TClonesArray *fArray;  // FIXME: Change TClonesArray away from a pointer?
  
  ULong_t fTotalEntries;
  
public:
  MPedestalCam(const char *name=NULL, const char *title=NULL);
  ~MPedestalCam();
  
  void Clear(Option_t *o="");
  
  void InitSize(const UInt_t i);
  
  MPedestalPix &operator[](Int_t i);
  const MPedestalPix &operator[](Int_t i) const;

  // Setters
  void SetTotalEntries(const ULong_t n)    { fTotalEntries = n; }

  // Getters
  Int_t   GetSize()                          const;
  ULong_t GetTotalEntries()                  const { return fTotalEntries; }

  Float_t GetPedestalMin(const MGeomCam *cam) const;
  Float_t GetPedestalMax(const MGeomCam *cam) const;
  
  void Print(Option_t *o="") const;
  
  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t idx) const;
  
  ClassDef(MPedestalCam, 1)	// Storage Container for all pedestal information of the camera
};

#endif

