#ifndef MARS_MRawRunHeader
#define MARS_MRawRunHeader
///////////////////////////////////////////////////////////////////////
//                                                                   //
// MRunHeader                                                        //
//                                                                   //
///////////////////////////////////////////////////////////////////////

#ifndef MARS_MTime
#include "MTime.h"
#endif

class TBuffer;
class MArrayS;

//
// Magic number to detect the magic file type
//
const UShort_t kMagicNumber = 0xc0c0;

//
// enum for the Run Type. Monte Carlo Runs have
// to have a value greater than 255 (>0xff)
//
enum {
    kRTData        = 0x0000,
    kRTPedestal    = 0x0001,
    kRTCalibration = 0x0002,
    kRTMonteCarlo  = 0x0100,
    kRTNone        = 0xffff
};

class MRawRunHeader : public MParContainer
{
private:
    /* ---- Run Header Informations ---- */
    UShort_t  fMagicNumber;
    UShort_t  fFormatVersion;
    UShort_t  fSoftVersion;
    UShort_t  fRunType;
    UInt_t    fRunNumber;
    Char_t    fProjectName[22];
    Char_t    fSourceName[12];
    Char_t    fSourceEpochChar[2];
    UShort_t  fSourceEpochDate;
    UShort_t  fNumCrates;
    UShort_t  fNumPixInCrate;
    UShort_t  fNumSamplesLoGain;
    UShort_t  fNumSamplesHiGain;
    UInt_t    fNumEvents;
    MTime     fRunStart;
    MTime     fRunStop;
    MArrayS  *fPixAssignment;

public:
    MRawRunHeader(const char *name=NULL, const char *title=NULL);
    ~MRawRunHeader();

    // This is to be used in the MC chain only!
    void SetMagicNumber(UShort_t a)       { fMagicNumber=a; }
    void SetFormatVersion(UShort_t a)     { fFormatVersion=a; }
    void SetSoftVersion(UShort_t a)       { fSoftVersion=a; }
    void SetRunType(UShort_t a)           { fRunType=a; }
    void SetRunNumber(UInt_t a)           { fRunNumber=a; }
    void SetNumEvents(UInt_t a)           { fNumEvents=a; }
    void SetNumSamples(UShort_t low, UShort_t high)
    {
        fNumSamplesLoGain=low;
        fNumSamplesHiGain=high;
    }
    void SetNumCrates(UShort_t a)         { fNumCrates=a; }
    void SetNumPixInCrate(UShort_t a)     { fNumPixInCrate=a; }
    void SetRunTime(Float_t start, Float_t stop)
    { fRunStart.SetMjd(start); fRunStop.SetMjd(stop); }

    // This is to get the numbers...
    UShort_t GetMagicNumber() const       { return fMagicNumber; }
    UShort_t GetFormatVersion() const     { return fFormatVersion; }
    UShort_t GetSoftVersion() const       { return fSoftVersion; }
    UShort_t GetRunType() const           { return fRunType; }
    const char *GetRunTypeStr() const;
    UInt_t   GetRunNumber() const         { return fRunNumber; }
    const Char_t  *GetProjectName() const { return fProjectName; }
    const Char_t  *GetSourceName() const  { return fSourceName; }
    const Char_t  *GetSourceEpocheChar() const { return fSourceEpochChar; }
    UShort_t GetSourceEpocheDate() const  { return fSourceEpochDate; }
    UShort_t GetNumCrates() const         { return fNumCrates; }
    UShort_t GetNumPixInCrate() const     { return fNumPixInCrate; }
    UShort_t GetNumSamplesLoGain() const  { return fNumSamplesLoGain; }
    UShort_t GetNumSamplesHiGain() const  { return fNumSamplesHiGain; }
    UInt_t   GetNumEvents() const         { return fNumEvents; }
    const MTime &GetRunStart() const      { return fRunStart; }
    const MTime &GetRunEnd() const        { return fRunStop; }
    UShort_t GetPixAssignment(UShort_t i) const;
    UShort_t GetMaxPixId() const;
    UShort_t GetNumConnectedPixels() const;

    UInt_t GetNumSamplesPerCrate() const
    {
        return fNumPixInCrate*(fNumSamplesLoGain+fNumSamplesHiGain);
    }

    UShort_t GetNumPixel() const;
    Int_t GetNumTotalBytes() const;

    void Print(Option_t *t=NULL) const;

    void ReadEvt(istream& fin);

    ClassDef(MRawRunHeader, 2)	// storage container for general info
};
#endif
