/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


Bool_t HandleInput()
{
    TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
    while (1)
    {
        //
        // While reading the input process gui events asynchronously
        //
        timer.TurnOn();
        TString input = Getline("Type 'q' to exit, <return> to go on: ");
        timer.TurnOff();

        if (input=="q\n")
            return kFALSE;

        if (input=="\n")
            return kTRUE;
    };

    return kFALSE;
}

MHCamera display[4];

TCanvas   *c;
MParList  *fParList;
MTaskList *fTaskList;

Int_t PreProcess(MParList *plist)
{
    fParList = plist;
    fTaskList = (MTaskList*)plist->FindObject("MTaskList");

    MGeomCam *geomcam = (MGeomCam*)plist->FindObject("MGeomCam");

    c = new TCanvas("Events", "Real Events", 600, 600);
    c->SetBorderMode(0);
    c->Divide(2,2);
    for (int i=0; i<4; i++)
    {
        display[i].SetGeometry(*geomcam);
        c->cd(i+1);
        display[i].Draw();
        gPad->cd(1);
        plist->FindObject("MHillas")->Draw();
    }
    return kTRUE;
}

Int_t Process()
{
    MReadMarsFile *read = (MReadMarsFile*)fTaskList->FindObject("MRead");
    MClone *clone = (MClone*)fTaskList->FindObject("MClone");
    MImgCleanStd *clean = (MImgCleanStd*)fTaskList->FindObject("MImgCleanStd");
    MGeomCam *geom = (MGeomCam*)fParList->FindObject("MGeomCam");

    cout << "Event #" << read->GetNumEntry() << ":" << endl;

    display[0].SetCamContent(*(MCerPhotEvt*)clone->GetClone());
    display[1].SetCamContent(*(MCerPhotEvt*)fParList->FindObject("MCerPhotEvt"));
    display[2].SetCamContent(*(MCameraData*)fParList->FindObject("MCameraData"));
    display[3].SetCamContent(*(MCameraData*)fParList->FindObject("MCameraData"));

    TArrayF lvl(2);
    lvl[0] = clean->GetCleanLvl2();
    lvl[1] = clean->GetCleanLvl1();
    display[3].SetLevels(lvl);

    for (int i=1; i<=4; i++)
    {
        c->GetPad(i)->GetPad(1)->Modified();
        c->GetPad(i)->GetPad(1)->Update();
    }

    ((MHillas*)fParList->FindObject("MHillas"))->Print(*geom);
    ((MHillasExt*)fParList->FindObject("MHillasExt"))->Print(*geom);
    fParList->FindObject("MNewImagePar")->Print();

    return HandleInput();
}

Int_t PostProcess()
{
    delete c;
}

void readMagic(const char *fname="../Proton*.root")
{               
    MParList  plist;
    MTaskList tlist;

    plist.AddToList(&tlist);

    MReadMarsFile read("Events", fname);
    read.DisableAutoScheme();

    MGeomApply geomapl;
    MPrint print1("MMcEvt");
    MPrint print2("MRawEvtHeader");
    print1.EnableSkip();
    print2.EnableSkip();

    MMcPedestalCopy   pcopy;
    MMcPedestalNSBAdd pnsb;
    MCerPhotAnal2     ncalc;
    MBlindPixelCalc   blind;
    blind.SetUseInterpolation();
    MClone            clone("MCerPhotEvt");
    MImgCleanStd      clean;
    MHillasCalc       hcalc;
    MTaskInteractive  mytask;

    mytask.SetPreProcess(PreProcess);
    mytask.SetProcess(Process);

    tlist.AddToList(&read);
    tlist.AddToList(&geomapl);
    tlist.AddToList(&print1);
    tlist.AddToList(&print2);
    tlist.AddToList(&pcopy);
    tlist.AddToList(&pnsb);
    tlist.AddToList(&ncalc);
    tlist.AddToList(&blind);
    tlist.AddToList(&clone);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);
    tlist.AddToList(&mytask);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();
}

