#ifndef MARS_MBadPixelsPix
#define MARS_MBadPixelsPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayC
#include <TArrayC.h>
#endif

class MBadPixelsPix : public MParContainer
{
private:
    TArrayC fInfo;

public:
    MBadPixelsPix(const char* name=NULL, const char* title=NULL);

    enum UnsuitableType_t {
        kUnsuitableRun = BIT(1),
        kUnsuitableEvt = BIT(2)
    };

    static const Char_t fgRunMask; // All types which are not event wise determined

    void Reset();
    void Clear(Option_t *o="");
    void Copy(TObject &object) const
    {
        static_cast<MBadPixelsPix&>(object).fInfo = fInfo;
    }

    // Setter
    void   SetUnsuitable(UnsuitableType_t typ=kUnsuitableRun) { fInfo[0] |=  typ; }
    void   SetSuitable(UnsuitableType_t typ=kUnsuitableRun)   { fInfo[0] &= ~typ; }

    // Getter
    Bool_t IsUnsuitable(UnsuitableType_t typ=kUnsuitableRun) const { return   fInfo[0]&typ; }
    Bool_t IsSuitable(UnsuitableType_t typ=kUnsuitableRun) const   { return !(fInfo[0]&typ); }

    Bool_t IsOK() const  { return fInfo[0]==0; }
    Bool_t IsBad() const { return fInfo[0]!=0; }

    void Merge(const MBadPixelsPix &pix);

    const TArrayC &GetInfo() const { return fInfo; }

    ClassDef(MBadPixelsPix, 1)	// Storage Container for bad pixel information of a single pixel
};

#endif

