#ifndef MARS_MExtractedSignalPINDiode
#define MARS_MExtractedSignalPINDiode

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MExtractedSignalPINDiode : public MParContainer
{
private:

  Float_t fExtractedSignal;    // mean value of the extracted signal
  Float_t fExtractedSignalErr; // error of the mean value of the extracted signal
  Float_t fExtractedTime; 
  Float_t fExtractedTimeErr; 
  Float_t fExtractedRms; 
  Float_t fExtractedRmsErr; 

  Byte_t fFirst;
  Byte_t fNumFADCSamples;
  Byte_t fNumSaturated;

public:
    MExtractedSignalPINDiode(const char* name=NULL, const char* title=NULL);

    void Clear(Option_t *o="");
    void Print(Option_t *o="") const;

    // Setter
    void SetExtractedSignal(const Float_t sig, const Float_t sigerr);
    void SetExtractedRms(  const Float_t sig, const Float_t sigerr);
    void SetExtractedTime(  const Float_t sig, const Float_t sigerr);
    void SetSaturation(   const Byte_t numsat);
    void SetUsedFADCSlices( const Byte_t first, const Byte_t num);
    
    // Getter
    Float_t GetExtractedSignal()    const { return fExtractedSignal; }
    Float_t GetExtractedSignalErr() const { return fExtractedSignalErr; }
    Float_t GetExtractedTime()      const { return fExtractedTime; }
    Float_t GetExtractedTimeErr()   const { return fExtractedTimeErr; }
    Float_t GetExtractedRms()       const { return fExtractedRms; }
    Float_t GetExtractedRmsErr()    const { return fExtractedRmsErr; }

    Byte_t  GetNumFADCSamples()     const { return fNumFADCSamples;  }
    

    
    Bool_t IsValid() const;   

    ClassDef(MExtractedSignalPINDiode, 0)	// Storage Container for Extracted Signal information of one pixel
};

#endif
