#ifndef MARS_MHCalibrationRelTimePix
#define MARS_MHCalibrationRelTimePix

#ifndef MARS_MHGausEvents
#include "MHGausEvents.h"
#endif

class MHCalibrationRelTimePix : public MHGausEvents
{

private:

  static const Int_t   fgPulserFrequency;

  static const Int_t   fgChargeNbins;
  static const Axis_t  fgChargeFirst;
  static const Axis_t  fgChargeLast;

  Int_t   fChargeNbins;
  Axis_t  fChargeFirst;
  Axis_t  fChargeLast;

  Int_t fPixId;                  // Pixel Nr

public:

  MHCalibrationRelTimePix(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationRelTimePix();

  void Clear(Option_t *o="");
  void InitBins();
  
  // Setters
  void SetChargeNbins(const Int_t  bins =fgChargeNbins)    { fChargeNbins = bins; }
  void SetChargeFirst(const Axis_t first=fgChargeFirst)    { fChargeFirst = first; }
  void SetChargeLast( const Axis_t last =fgChargeLast)     { fChargeLast  = last; }

  void SetPulserFrequency(Float_t f=fgPulserFrequency);

  // Fits
  void BypassFit();
  
  // Others
  void ChangeHistId(Int_t i);
  void Renorm(const Float_t slicewidth);
  
  //  TObject *DrawClone(Option_t *opt="") const;
  
  ClassDef(MHCalibrationRelTimePix, 1)     // Histograms for each calibrated pixel
};

#endif
