#ifndef MARS_MSigmabarCalc
#define MARS_MSigmabarCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MGeomCam
#include "MGeomCam.h"
#endif

#ifndef MARS_MMcEvt
#include "MMcEvt.hxx"
#endif

#ifndef MARS_MPedPhotCam
#include "MPedPhotCam.h"
#endif

#ifndef MARS_MSigmabar
#include "MSigmabar.h"
#endif

#ifndef MARS_MSigmabarParam
#include "MSigmabarParam.h"
#endif

#ifndef MARS_MRawRunHeader
#include "MRawRunHeader.h"
#endif

class MSigmabarCalc : public MTask
{
private:
    MMcEvt         *fMcEvt;
    MCerPhotEvt    *fEvt;
    MGeomCam       *fCam;
    MPedPhotCam   *fPed;
    MRawRunHeader  *fRun;
    MSigmabar      *fSig;
    MSigmabarParam *fSigParam;

    Double_t fSigmabarMin; // Parametrization
    Double_t fSigmabarMax;
    Double_t fThetaMin;
    Double_t fThetaMax;

    void Reset();

    Int_t PreProcess(MParList *pList);
    Int_t Process();

    Bool_t ReInit(MParList *pList);

public:
    MSigmabarCalc(const char *name=NULL, const char *title=NULL);

    ClassDef(MSigmabarCalc, 0) // task for calculating sigmabar
}; 

#endif



