#ifndef MARS_MJCalibration
#define MARS_MJCalibration

#ifndef MARS_MCalibrationChargeCam
#include "MCalibrationChargeCam.h"
#endif
#ifndef MARS_MBadPixelsCam
#include "MBadPixelsCam.h"
#endif

class TCanvas;
class MHCamera;
class MCamEvent;
class MRunIter;
class MParList;
class MPedestalCam;

class MJCalibration : public MParContainer
{
private:
    TString fOutputPath;

    MRunIter *fRuns;

    MCalibrationChargeCam fCalibrationCam;
    MBadPixelsCam         fBadPixels;

    void DrawProjection(MHCamera *obj1, Int_t fit) const;
    void CamDraw(TCanvas &c, const Int_t x, const Int_t y, const MHCamera &cam1, const Int_t fit);

    void   DisplayResult(MParList &plist);
    Bool_t WriteResult();

public:
    MJCalibration(const char *name=NULL, const char *title=NULL);

    void SetInput(MRunIter *iter) { fRuns=iter; }
    void SetOutputPath(const char *path=".");

    TString GetOutputFile() const;

    const MCalibrationChargeCam &GetCalibrationCam() const { return fCalibrationCam; }
    const MBadPixelsCam         &GetBadPixels()      const { return fBadPixels; }

    void SetBadPixels(MBadPixelsCam &bad) { bad.Copy(fBadPixels); }

    Bool_t ReadCalibrationCam();
    Bool_t ProcessFile(MPedestalCam &pedcam);
    Bool_t Process(MPedestalCam &pedcam);

    ClassDef(MJCalibration, 0) // Tool to create a pedestal file (MPedestalCam)
};

#endif
