#ifndef MARS_MCalibrationChargeBlindPix
#define MARS_MCalibrationChargeBlindPix

#ifndef MARS_MCalibrationChargePix
#include "MCalibrationChargePix.h"
#endif

class MCalibrationChargeBlindPix : public MCalibrationChargePix
{
private:

  static const Float_t fgLambdaCheckLimit;  // The default limit (in units of PedRMS) for acceptance of the fitted mean charge
  static const Float_t fgLambdaErrLimit;    // The default limit (in units of PedRMS) for acceptance of the fitted charge sigma

  static const Float_t gkBlindPixelArea;       // The Blind Pixel area in mm^2

  static const Float_t gkBlindPixelQEGreen;
  static const Float_t gkBlindPixelQEBlue ;
  static const Float_t gkBlindPixelQEUV   ;
  static const Float_t gkBlindPixelQECT1  ;

  static const Float_t gkBlindPixelQEGreenErr;
  static const Float_t gkBlindPixelQEBlueErr ;
  static const Float_t gkBlindPixelQEUVErr   ;
  static const Float_t gkBlindPixelQECT1Err  ;
 
  static const Float_t gkBlindPixelAttGreen;
  static const Float_t gkBlindPixelAttBlue ;
  static const Float_t gkBlindPixelAttUV   ;
  static const Float_t gkBlindPixelAttCT1  ;

  Float_t fLambdaCheckLimit; // The rel. limit for the rel difference between lambda and lambda check
  Float_t fLambdaErrLimit;   // The limit for acceptance of the fitted lambda

  Float_t fLambda;           // The mean of the Poisson fit
  Float_t fLambdaCheck;      // The mean of the pedestal Check fit
  Float_t fMu0;              // The position of the pedestal-peak
  Float_t fMu1;              // The position of the first phe-peak
  Float_t fSigma0;           // The width of the pedestal-peak
  Float_t fSigma1;           // The width of the first phe-peak  

  Float_t fLambdaErr;        // The error of the mean charge after the fit
  Float_t fLambdaCheckErr;   // The error of the mean of the pedestal Check fit
  Float_t fMu0Err;           // The error of the position of the pedestal-peak
  Float_t fMu1Err;           // The error of the position of the first phe-peak
  Float_t fSigma0Err;        // The error of the width of the pedestal-peak
  Float_t fSigma1Err;        // The error of the width of the first phe-peak  

  Float_t fProb;             // The probability of the fit
  
  Float_t fMeanFluxInsidePlexiglass;          //  The mean number of photons in an INNER PIXEL inside the plexiglass
  Float_t fMeanFluxErrInsidePlexiglass;       //  The uncertainty about the number of photons in an INNER PIXEL  

  Byte_t fFlags;

  enum { kOscillating, kPedestalFitOK, kSinglePheFitOK, kChargeFitValid, kExcluded, 
         kFluxInsidePlexiglassAvailable };

  PulserColor_t fColor;  

public:

  MCalibrationChargeBlindPix(const char *name=NULL, const char *title=NULL);
  ~MCalibrationChargeBlindPix() {}
  
  void Clear(Option_t *o="");

  // Setters
  void SetColor       ( const PulserColor_t color )  {  fColor = color;  }

  void SetLambda      ( const Float_t f ) { fLambda      = f;  }
  void SetLambdaCheck ( const Float_t f ) { fLambdaCheck = f;  }
  void SetMu0         ( const Float_t f ) { fMu0         = f;  }
  void SetMu1         ( const Float_t f ) { fMu1         = f;  }
  void SetSigma0      ( const Float_t f ) { fSigma0      = f;  }
  void SetSigma1      ( const Float_t f ) { fSigma1      = f;  }

  void SetLambdaErr       ( const Float_t f ) { fLambdaErr    = f;  }
  void SetLambdaCheckErr  ( const Float_t f ) { fLambdaCheck = f;   }
  void SetMu0Err          ( const Float_t f ) { fMu0Err       = f;  }
  void SetMu1Err          ( const Float_t f ) { fMu1Err       = f;  }
  void SetSigma0Err       ( const Float_t f ) { fSigma0Err    = f;  }
  void SetSigma1Err       ( const Float_t f ) { fSigma1Err    = f;  }

  void SetProb            ( const Float_t f ) { fProb         = f;  }

  void SetLambdaCheckLimit ( const Float_t f=fgLambdaCheckLimit  ) { fLambdaCheckLimit  = f; }
  void SetLambdaErrLimit   ( const Float_t f=fgLambdaErrLimit    ) { fLambdaErrLimit    = f; }

  void SetOscillating     ( const Bool_t b=kTRUE);
  void SetChargeFitValid  ( const Bool_t b=kTRUE);
  void SetPedestalFitOK   ( const Bool_t b=kTRUE);
  void SetSinglePheFitOK ( const Bool_t b=kTRUE);
  void SetFluxInsidePlexiglassAvailable  ( const Bool_t b=kTRUE);
  void SetExcluded        ( const Bool_t b=kTRUE);
  
  // Getters
  Float_t GetLambda()      const    { return fLambda;      }
  Float_t GetLambdaCheck() const    { return fLambdaCheck; }
  Float_t GetMu0()         const    { return fMu0;         }
  Float_t GetMu1()         const    { return fMu1;         }
  Float_t GetSigma0()      const    { return fSigma0;      }
  Float_t GetSigma1()      const    { return fSigma1;      }

  Float_t GetLambdaErr()      const    { return fLambdaErr;      }
  Float_t GetLambdaCheckErr() const    { return fLambdaCheckErr; }
  Float_t GetMu0Err()         const    { return fMu0Err;         }
  Float_t GetMu1Err()         const    { return fMu1Err;         }
  Float_t GetSigma0Err()      const    { return fSigma0Err;      } 
  Float_t GetSigma1Err()      const    { return fSigma1Err;      }

  Float_t GetMeanFluxInsidePlexiglass()     const { return fMeanFluxInsidePlexiglass;     }
  Float_t GetMeanFluxErrInsidePlexiglass()  const { return fMeanFluxErrInsidePlexiglass;  }

  Bool_t  IsOscillating()                    const;
  Bool_t  IsChargeFitValid()                 const;
  Bool_t  IsPedestalFitOK()                  const;
  Bool_t  IsSinglePheFitOK()                 const;
  Bool_t  IsExcluded()                       const;
  Bool_t  IsFluxInsidePlexiglassAvailable()  const;
  
  Bool_t CalcFluxInsidePlexiglass();
  Bool_t CheckChargeFitValidity();

  ClassDef(MCalibrationChargeBlindPix, 1)	// Container for Calibration ChargeBlind Pixel
};

#endif




