#ifndef COSY_Ring
#define COSY_Ring

#ifndef ROOT_TObject
#include <TObject.h>
#endif

class Leds;
class Rings;

class Ring : public TObject
{
private:
    Double_t fX;
    Double_t fY;
    Double_t fR;
    Double_t fPhi;

    Double_t fDx;
    Double_t fDy;
    Double_t fDr;
    Double_t fDphi;

    Double_t sqr(Double_t x) { return x*x; }

    void Swap(int *m, int *n)
    {
        int dummy = *m;
        *m = *n;
        *n = dummy;
    }

public:
    Ring();

    Double_t GetX() const   { return fX; }
    Double_t GetY() const   { return fY; }
    Double_t GetR() const   { return fR; }
    Double_t GetPhi() const { return fPhi; }

    bool CalcCenter(const Leds &leds, Int_t i, Int_t j, Int_t k);
    void InterpolCenters(const Rings &rings);

    void Print(Option_t *o=NULL) const;

    ClassDef(Ring, 1)
};

#endif
