#ifndef MARS_MCalibrationQEPix
#define MARS_MCalibrationQEPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MCalibrationQEPix : public MParContainer
{
private:

  Int_t fPixId;

  Float_t fQEGreen;
  Float_t fQEBlue;
  Float_t fQEUV;
  Float_t fQECT1;
  
  Float_t fQEGreenErr;
  Float_t fQEBlueErr;
  Float_t fQEUVErr;
  Float_t fQECT1Err;   
  
  Byte_t fFlags;

  enum { kExcluded, kQEValid };

public:

  MCalibrationQEPix(const char *name=NULL, const char *title=NULL);
  ~MCalibrationQEPix() {}
  
  void Clear(Option_t *o="");

  // Setters
  void SetQE   ( const Float_t qe   , const PulserColor_t col );
  void SetQEErr( const Float_t qeerr, const PulserColor_t col );

  void SetExcluded            (  const Bool_t b = kTRUE );
  void SetQEValid             (  const Bool_t b = kTRUE );

  // Getters
  Float_t GetQE   ( const PulserColor_t col )  const;
  Float_t GetQEErr( const PulserColor_t col )  const;
  Int_t   GetPixId()          const;

  Bool_t IsExcluded()         const;
  Bool_t IsQEValid()          const;

  void   SetPixId(const Int_t i)     { fPixId = i; }

  // Miscellaneous
  Bool_t CheckQEValidity();

  ClassDef(MCalibrationQEPix, 1)	// Container for calibrated Quantrum Efficieny of one pixel
};

#endif

