#ifndef MARS_MHPedestalPix
#define MARS_MHPedestalPix

#ifndef MARS_MHGausEvents
#include "MHGausEvents.h"
#endif

class MHPedestalPix : public MHGausEvents
{

private:

  static const Int_t   fgChargeNbins;
  static const Axis_t  fgChargeFirst;
  static const Axis_t  fgChargeLast;

  Int_t   fChargeNbins;
  Axis_t  fChargeFirst;
  Axis_t  fChargeLast;

  Int_t fPixId;                  // Pixel Nr

public:

  MHPedestalPix(const char *name=NULL, const char *title=NULL);
  ~MHPedestalPix();

  void Clear(Option_t *o="");
  void InitBins();
  
  // Setters
  void SetChargeNbins(const Int_t  bins =fgChargeNbins)    { fChargeNbins = bins; }
  void SetChargeFirst(const Axis_t first=fgChargeFirst)    { fChargeFirst = first; }
  void SetChargeLast( const Axis_t last =fgChargeLast)     { fChargeLast  = last; }
  
  // Others
  void ChangeHistId(Int_t i);
  void Renorm(const Float_t nslices);  

  //  TObject *DrawClone(Option_t *opt="") const;
  
  ClassDef(MHPedestalPix, 1)     // Histograms for each calibrated pixel
};

#endif
