#ifndef MARS_MMcCollectionAreaCalc
#define MARS_MMcCollectionAreaCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#include <TH2.h>

class MParList;
class MMcEvt;
class MMcTrig;
class MHMcCollectionArea;

class MMcCollectionAreaCalc : public MTask
{
private:
    const MMcEvt  *fMcEvt;
    const MMcTrig *fMcTrig;

    MHMcCollectionArea *fCollArea;

    TString fObjName;

    UInt_t fTotalNumSimulatedShowers;
    UInt_t fCorsikaVersion;
    Bool_t fAllEvtsTriggered;
    Float_t fTheta;

    Bool_t ReInit(MParList *plist);

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

public:
    MMcCollectionAreaCalc(const char *input=NULL,
                          const char *name=NULL, const char *title=NULL);

    ClassDef(MMcCollectionAreaCalc, 0) // Task to calculate the collection area histogram
};

#endif 

