#ifndef MARS_MAstroCamera
#define MARS_MAstroCamera

#ifndef MARS_MAstroCatalog
#include "MAstroCatalog.h"
#endif

class TClonesArray;

class MTime;
class MGeomCam;
class MGeomMirror;
class MObservatory;

class MAstroCamera : public MAstroCatalog
{
private:
    MGeomCam     *fGeom;
    TClonesArray *fMirrors;

    MGeomMirror  *fMirror0;     //!

    Int_t  Convert(const TRotation &rot, TVector2 &v, Int_t type);
    void   AddPrimitives(Option_t *o);
    void   SetRangePad() { }
    void   DrawNet(const TRotation &rot);
    void   ExecuteEvent(Int_t event, Int_t mp1, Int_t mp2);

public:
    MAstroCamera();
    ~MAstroCamera();

    void SetMirrors(TClonesArray *arr);
    void SetGeom(const MGeomCam &cam);

    ClassDef(MAstroCamera, 1)
};

#endif
