#ifndef MARS_MCalibrationChargeCalc
#define MARS_MCalibrationChargeCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrationChargeCalc                                                   //
//                                                                         //
// Integrates the time slices of the all pixels of a calibration event     //
// and substract the pedestal value                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MRawRunHeader;
class MPedestalCam;
class MCalibrationChargePINDiode;
class MCalibrationChargeBlindPix;
class MCalibrationChargeCam;
class MGeomCam;
class MExtractedSignalCam;
class MBadPixelsCam;
class MTime;
class MCalibrationChargeCalc : public MTask
{
private:

  MPedestalCam               *fPedestals;                 //! Pedestals of all pixels in the camera
  MCalibrationChargeCam      *fCam;                       // Calibration events of all pixels in the camera
  MRawEvtData                *fRawEvt;                    //! raw event data (time slices)
  MRawRunHeader              *fRunHeader;                 //! RunHeader information
  MGeomCam                   *fGeom;                      //! Geometry information
  MBadPixelsCam              *fBadPixels;                 //! Bad Pixels information
  
  MTime                      *fEvtTime;                   //! Time of the event

  MExtractedSignalCam        *fSignals;                   // Extracted signal of all pixels in the camera
  MCalibrationChargePINDiode *fPINDiode;                  // Calibration results of the PIN Diode
  MCalibrationChargeBlindPix *fBlindPixel;                // Calibration results of the Blind Pixel 

  Float_t  fNumHiGainSamples; 
  Float_t  fNumLoGainSamples; 
  Float_t  fSqrtHiGainSamples;
  Float_t  fSqrtLoGainSamples; 
  
  Float_t fConversionHiLo;
  Int_t   fFlags;                                // Flag for the fits used

  enum  { kUseQualityChecks,
          kHiLoGainCalibration };
  
  Int_t  PreProcess(MParList *pList);
  Bool_t ReInit(MParList *pList); 
  Int_t  Process();
  Int_t  PostProcess();
  
public:

  MCalibrationChargeCalc(const char *name=NULL, const char *title=NULL);

  void Clear(const Option_t *o="");
  
  void SkipQualityChecks(Bool_t b=kTRUE)
      {b ? CLRBIT(fFlags, kUseQualityChecks)    : SETBIT(fFlags, kUseQualityChecks);}
  void SkipHiLoGainCalibration(Bool_t b=kTRUE)
      {b ? CLRBIT(fFlags, kHiLoGainCalibration) : SETBIT(fFlags, kHiLoGainCalibration);}

  ClassDef(MCalibrationChargeCalc, 1)   // Task to fill the Calibration Containers from raw data
};

#endif
