#ifndef MARS_MHCalibrationChargePINDiode
#define MARS_MHCalibrationChargePINDiode


#ifndef MARS_MHCalibrationChargePix
#include "MHCalibrationChargePix.h"
#endif

class TH1F;
class MCalibrationChargePINDiode;
class MHCalibrationChargePINDiode : public MHCalibrationChargePix
{
private:

  MCalibrationChargePINDiode *fPINDiode;  //! Storage container of the results

  TH1F fHRmsCharge;                       // Variance of summed FADC slices

  static const Int_t   fgChargeNbins;
  static const Axis_t  fgChargeFirst;
  static const Axis_t  fgChargeLast;  

  static const Int_t   fgRmsChargeNbins;
  static const Axis_t  fgRmsChargeFirst;
  static const Axis_t  fgRmsChargeLast;  

  static const Int_t   fgAbsTimeNbins;
  static const Axis_t  fgAbsTimeFirst;
  static const Axis_t  fgAbsTimeLast;

  Int_t   fRmsChargeNbins;
  Axis_t  fRmsChargeFirst;
  Axis_t  fRmsChargeLast;  

  Float_t  fRmsChargeMean;
  Float_t  fRmsChargeMeanErr;
  Float_t  fRmsChargeSigma;
  Float_t  fRmsChargeSigmaErr;

  Float_t fExtractSlices;
  
public:

  MHCalibrationChargePINDiode(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargePINDiode(){}

  void Clear(Option_t *o="");
  void Init();
  
  Bool_t SetupFill(const MParList *pList);
  Bool_t ReInit   (      MParList *pList);
  Bool_t Fill     (const MParContainer *par, const Stat_t w=1);
  Bool_t Finalize();

  // Setters
  void SetChargeNbins(const Int_t  bins =fgChargeNbins)          { fChargeNbins = bins;     }
  void SetChargeFirst(const Axis_t first=fgChargeFirst)          { fChargeFirst = first;    }
  void SetChargeLast( const Axis_t last =fgChargeLast)           { fChargeLast  = last;     }
  
  void SetAbsTimeNbins(const Int_t  bins =fgAbsTimeNbins)        { fAbsTimeNbins = bins;    }
  void SetAbsTimeFirst(const Axis_t first=fgAbsTimeFirst)        { fAbsTimeFirst = first;   }
  void SetAbsTimeLast( const Axis_t last =fgAbsTimeLast)         { fAbsTimeLast  = last;    }

  void SetRmsChargeNbins(const Int_t  bins =fgRmsChargeNbins)    { fRmsChargeNbins = bins;  }
  void SetRmsChargeFirst(const Axis_t first=fgRmsChargeFirst)    { fRmsChargeFirst = first; }
  void SetRmsChargeLast( const Axis_t last =fgRmsChargeLast)     { fRmsChargeLast  = last;  }

  // Getters
  TH1F *GetHRmsCharge()                        { return &fHRmsCharge;  }
  const TH1F *GetHRmsCharge()            const { return &fHRmsCharge;  }

  Float_t  GetRmsChargeMean()            const { return fRmsChargeMean; }
  Float_t  GetRmsChargeMeanErr()         const { return fRmsChargeMeanErr; }
  Float_t  GetRmsChargeSigma()           const { return fRmsChargeSigma; }
  Float_t  GetRmsChargeSigmaErr()        const { return fRmsChargeSigmaErr; }

  // Fill histos
  Bool_t FillRmsCharge(const Float_t q);

  // Fits
  Bool_t FitRmsCharge(Option_t *option="RQ0");

  // Draw
  void Draw(Option_t *opt="");
  
  ClassDef(MHCalibrationChargePINDiode, 1)  // Histogram class for the Calibration PIN Diode
};

#endif

