/***************************************************************************
                          amclookuptable.cpp  -  description
                             -------------------
    begin                : Sun Sep 28 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "amclookuptable.h"
#include "amcmirrorpanel.h"
#include "magicmirror.h"
#include "math.h"
#include "stdlib.h"
#include <qdir.h>
#include <qfile.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qtextstream.h>

extern MagicMirror*		g_theMirror;


/** Static method to find the next matching LUT */
QString AMCLookUpTable::findLUT( double p_dZd, double p_dAz )
{
	// Round Zenith distance and Azimuth to next ten degree value
	int iZd = (int) (rint( p_dZd ));
	int iAz  = (int) (rint( p_dAz ));
	qDebug( "Searching for LUT near Alt: %2d Az: %3d", iZd, iAz );

	QDir shareDir( "/home/amc/share/amc", "*.lut" );

	int iZdMin = 90;
	int iAzMin = 360;
	int iIndex = -1;
	for ( unsigned int i=0; i<shareDir.count(); i++ )
	{
		int iFileZd = shareDir[i].mid(5,2).toInt();

		if( abs( iZd - iFileZd ) <= iZdMin )
		{
			iZdMin = abs( iZd - iFileZd );
		}
	}

	for ( unsigned int i=0; i<shareDir.count(); i++ )
	{
		int iFileZd = shareDir[i].mid(5,2).toInt();
		int iFileAz = shareDir[i].mid(8,3).toInt();

		if( abs( iZd - iFileZd ) == iZdMin )
		{
			if( abs( iAz - iFileAz ) <= iAzMin )
			{
				iIndex = i;
				iAzMin = abs( iAz - iFileAz );
			}
		}
	}

	if( iIndex == -1 ) 	
		return 0;

	QString qsFileName;
	qsFileName.sprintf( "/home/amc/share/amc/%s", shareDir[iIndex].latin1() );
	qDebug( "Using LUT %d %s", iIndex, qsFileName.latin1() );

	readLUT( qsFileName );
	return qsFileName;
}

/** No descriptions */
void AMCLookUpTable::saveLUT( double p_dZd, double p_dAz )
{
	// Round Altitude and Azimuth to next 5 degree value
	int iZd = (int) (rint( p_dZd / 5.0 )) * 5;
	int iAz = (int) (rint( p_dAz / 5.0 )) * 5;

	QDateTime theDT = QDateTime::currentDateTime();
	QDate theDate = theDT.date();
	QTime theTime = theDT.time();

	QString qsFileName;
	qsFileName.sprintf( "/home/amc/data/AMC_%04d_%02d_%02d_%02d_%02d_%02d__(%02d_%03d).lut",
                      theDate.year(), theDate.month(), theDate.day(),
                      theTime.hour(), theTime.minute(), theTime.second(),
											iZd, iAz );
	QFile file( qsFileName );

	QCString line;

	if( file.open( IO_WriteOnly ) )
	{
		QTextStream stream( &file );
		for(int j=0; j<17; j++)
		{
			line.sprintf("# Column %d\n",j-8);
			stream << line;
			for(int i=0; i<17; i++)
			{
				AMCMirrorPanel* pPanel = g_theMirror->panelAt( i, j );
				line.sprintf( "%3d %3d\t%5d\t%5d\t%5d\t%5d\n",
											pPanel->i(),
											pPanel->j(),
											pPanel->getX(),
											pPanel->getY(),
											pPanel->getLaserX(),
											pPanel->getLaserY() );
				stream << line;
			}
		}
					
	}
}

/** No descriptions */
void AMCLookUpTable::readLUT( const QString& p_qsFileName )
{

	QFile file( p_qsFileName );
	if( file.open( IO_ReadOnly ) )
	{
		QTextStream stream( &file );
		QString line;
		while( !stream.eof() )
		{
			line = stream.readLine();
		
			// Skip comment lines
			if( line[0] == '#')
				continue;
					
			int ii, ij, iX, iY, iLaserX, iLaserY;
			sscanf( line.data(),"%d %d %d %d %d %d",
							&ii, &ij, &iX, &iY, &iLaserX, &iLaserY );
			AMCMirrorPanel* pPanel = g_theMirror->panelAt( ii+8, ij+8 );
			pPanel->setRefX( iX );
			pPanel->setRefY( iY );
//			pPanel->setLaserX( iLaserX );
//			pPanel->setLaserY( iLaserY );
		}
	}
}
