#ifndef MARS_MCalibrationQECam
#define MARS_MCalibrationQECam

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif
#ifndef MARS_MCamEvent
#include "MCamEvent.h"
#endif

class TClonesArray;

class MCalibrationQEPix;
class MCalibrationQECam : public MParContainer, public MCamEvent
{
private:
  
  Int_t fNumPixels;
  TClonesArray *fPixels;                                        //-> Array of MCalibrationPix with fit results
  
public:

  MCalibrationQECam(const char *name=NULL, const char *title=NULL);
  ~MCalibrationQECam();
  
  void Clear(    Option_t *o="" );
  void InitSize( const UInt_t i );

  // Getters
  Int_t  GetSize()               const;
  UInt_t GetNumPixels()          const { return fNumPixels; }

  // Others
  MCalibrationQEPix &operator[](UInt_t i);
  const MCalibrationQEPix &operator[](UInt_t i) const;
  
  // Prints
  void Print(Option_t *o="") const;
  
  // Others
  Bool_t GetPixelContent(Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void DrawPixelContent(Int_t num) const;    

  ClassDef(MCalibrationQECam, 1)	// Container for calibration information of the camera
};

#endif





