#ifndef MARS_MBadPixelsTreat
#define MARS_MBadPixelsTreat

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MPedPhotCam;
class MBadPixelsCam;

class MBadPixelsTreat : public MTask
{
private:
    MGeomCam      *fGeomCam;   //!
    MPedPhotCam   *fPedPhot;   //!
    MCerPhotEvt   *fEvt;       //!
    MBadPixelsCam *fBadPixels; //!

    Byte_t fFlags;       // flag for the method which is used

    enum
    {
        kUseInterpolation = BIT(1),
        kUseCentralPixel  = BIT(2),
    };

    static Double_t Pow2(Double_t x) { return x*x; }

    void InterpolateSignal() const;
    void InterpolatePedestals() const;

    void  Interpolate() const;
    void  Unmap() const;
    void  StreamPrimitive(ofstream &out) const;

    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MBadPixelsTreat(const char *name=NULL, const char *title=NULL);

    void SetUseInterpolation(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kUseInterpolation) : CLRBIT(fFlags, kUseInterpolation);
    }
    void SetUseCentralPixel(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kUseCentralPixel) : CLRBIT(fFlags, kUseCentralPixel);
    }


    ClassDef(MBadPixelsTreat, 1) // Task to treat bad pixels (interpolation, unmapping)
}; 

#endif

