#ifndef MARS_MCalibrateData
#define MARS_MCalibrateData

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrateData
//                                                                         //
// Integrates the desired ADC time slices of one pixel and apply           //
// calibration constants                                                   //
//                                                                         //
// Differences between MCalibrateData and MCalibrate :
// in MCalibrateData
// - in ReInit the MPedPhot container is filled using
//      - the pedstals/slice from MPedestalCam
//      - the number of used FADC slices from MExtractedSignalCam   
//      - the photon/ADC conversion factor from MCalibrationCam
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MBadPixelsCam;
class MPedestalCam;
class MCalibrationChargeCam;
class MExtractedSignalCam;

class MPedPhotCam;
class MCerPhotEvt;

class MCalibrateData : public MTask
{
private:
    MGeomCam              *fCam;
    MPedestalCam          *fPedestal;     // Pedestals/slice [ADC counts]
    MBadPixelsCam         *fBadPixels;    // Bad Pixels information
    MCalibrationChargeCam *fCalibrations; // Calibration constants 
    MExtractedSignalCam   *fSignals;      // Integrated charge in FADCs counts

    MPedPhotCam           *fPedPhot;      // Pedestals/(used slices) [photons]
    MCerPhotEvt           *fCerPhotEvt;   // Cerenkov Photon Event used for calculation

    Float_t fNumUsedHiGainFADCSlices;
    Float_t fNumUsedLoGainFADCSlices;

    Float_t  fConversionHiLo;
    UShort_t fCalibrationMode;

    Bool_t GetConversionFactor(UInt_t, 
                               Float_t &, Float_t &, Float_t &, Float_t &);    

    Int_t  PreProcess(MParList *pList);
    Bool_t ReInit(MParList *pList);
    Int_t  Process();

public:

    enum CalibrationMode_t{kNone=0,kBlindPixel,kFfactor,kPinDiode,kCombined};
    static const CalibrationMode_t kDefault = kBlindPixel;

    MCalibrateData(CalibrationMode_t calmode = kDefault,const char *name=NULL, const char *title=NULL);

    void SetConversionHiLo(Float_t conv) { fConversionHiLo = conv; };
    void SetCalibrationMode(CalibrationMode_t calmode=kDefault){ fCalibrationMode=calmode;};
    
    ClassDef(MCalibrateData, 0)   // Task to calculate cerenkov photons using calibration constants
};
 

#endif









