#ifndef MARS_MCalibrationChargePINDiode
#define MARS_MCalibrationChargePINDiode

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MCalibrationChargePINDiode : public MParContainer
{
private:

  static const Float_t fgChargeLimit;       // The default limit (in units of PedRMS) for acceptance of the fitted mean charge
  static const Float_t fgChargeErrLimit;    // The default limit (in units of PedRMS) for acceptance of the fitted charge sigma
  static const Float_t fgChargeRelErrLimit; // The default limit (in units of Error of fitted charge) for acceptance of the fitted mean  

  static const Float_t fgConversionChargePhotons;    // The default mean conversion from PIN Diode charge to the number of incident photons
  static const Float_t fgConversionChargePhotonsErr; // The default error of the mean conversion from PIN Diode charge to the number of incident photons

  static const Float_t gkPINDiodeArea;         // The Blind Pixel area in mm^2  

  static const Float_t gkFluxCameravsPINDiode     ;
  static const Float_t gkFluxCameravsPINDiodeErr  ;
  
  static const Float_t gkPINDiodeQEGreen;
  static const Float_t gkPINDiodeQEBlue ;
  static const Float_t gkPINDiodeQEUV   ;
  static const Float_t gkPINDiodeQECT1  ;
  
  static const Float_t gkPINDiodeQEGreenErr;
  static const Float_t gkPINDiodeQEBlueErr ;
  static const Float_t gkPINDiodeQEUVErr   ;
  static const Float_t gkPINDiodeQECT1Err  ;
 
  Float_t fChargeLimit;                     // The limit (in units of PedRMS) for acceptance of the fitted mean charge
  Float_t fChargeErrLimit;                  // The limit (in units of PedRMS) for acceptance of the fitted charge sigma
  Float_t fChargeRelErrLimit;               // The limit (in units of Error of fitted charge) for acceptance of the fitted mean  
  
  Float_t fConversionChargePhotons;         // The mean conversion from PIN Diode charge to the number of incident photons
  Float_t fConversionChargePhotonsErr;      // The error of the mean conversion from PIN Diode charge to the number of incident photons

  Float_t fPed;                   // The mean pedestal (from MPedestalPix)
  Float_t fPedRms;                // The pedestal  RMS (from MPedestalPix)

  Float_t fMeanCharge;            // The mean charge after the fit
  Float_t fMeanChargeErr;         // The error of mean charge after the fit
  Float_t fSigmaCharge;           // The sigma of the mean charge after the fit
  Float_t fSigmaChargeErr;        // The error of the sigma of the mean charge after the fit
  Float_t fChargeProb;            // The probability of the fit function 

  Float_t fRmsChargeMean;
  Float_t fRmsChargeMeanErr;
  Float_t fRmsChargeSigma;  
  Float_t fRmsChargeSigmaErr;

  Byte_t  fFlags;                            // Flag for the set Bits

  Float_t fAbsTimeMean;
  Float_t fAbsTimeRms;

  Float_t fTimeLowerEdge;
  Float_t fTimeUpperEdge;

  Float_t fConvertedPhotons;
  Float_t fConvertedPhotonsErr;

  Float_t fMeanFluxOutsidePlexiglass;         //  The mean number of photons in an INNER PIXEL outside the plexiglass
  Float_t fMeanFluxErrOutsidePlexiglass;      //  The uncertainty about the number of photons in an INNER PIXEL  

  PulserColor_t fColor;  

  enum  { kExcluded, kExcludeQualityCheck, kOscillating,
          kChargeFitValid, kTimeFitValid, 
	  kMeanTimeInFirstBin, kMeanTimeInLastBin, 
	  kFluxOutsidePlexiglassAvailable  };    

public:

  MCalibrationChargePINDiode(const char *name=NULL, const char *title=NULL);
  ~MCalibrationChargePINDiode() {}
  
  void Clear(Option_t *o="");
  
  // Setters
  void SetColor(   const PulserColor_t color )  {  fColor = color;         }

  void SetMeanCharge     (   const Float_t f )    { fMeanCharge        = f;  }
  void SetMeanChargeErr  (   const Float_t f )    { fMeanChargeErr     = f;  }
  void SetSigmaCharge    (   const Float_t f )    { fSigmaCharge       = f;  }
  void SetSigmaChargeErr (   const Float_t f )    { fSigmaChargeErr    = f;  }

  void SetRmsChargeMean    ( const Float_t f )    { fRmsChargeMean     = f;  }
  void SetRmsChargeMeanErr ( const Float_t f )    { fRmsChargeMeanErr  = f;  }
  void SetRmsChargeSigma   ( const Float_t f )    { fRmsChargeSigma    = f;  }
  void SetRmsChargeSigmaErr( const Float_t f )    { fRmsChargeSigmaErr = f;  }

  void SetAbsTimeMean    (   const Float_t f )    { fAbsTimeMean       = f;  }
  void SetAbsTimeRms     (   const Float_t f )    { fAbsTimeRms        = f;  }

  void SetChargeLimit    (   const Float_t f=fgChargeLimit       ) { fChargeLimit       = f; }
  void SetChargeErrLimit (   const Float_t f=fgChargeErrLimit    ) { fChargeErrLimit    = f; }
  void SetChargeRelErrLimit( const Float_t f=fgChargeRelErrLimit ) { fChargeRelErrLimit = f; }

  void SetConversionChargePhotons    ( const Float_t f=fgConversionChargePhotons    ) { fConversionChargePhotons    = f; }  
  void SetConversionChargePhotonsErr ( const Float_t f=fgConversionChargePhotonsErr ) { fConversionChargePhotonsErr = f; }  

  void SetPedestal(Float_t ped, Float_t pedrms);

  void SetOscillating     ( const Bool_t b=kTRUE);
  void SetExcluded           ( const Bool_t b = kTRUE );
  void SetExcludeQualityCheck( const Bool_t b = kTRUE );
  void SetChargeFitValid     ( const Bool_t b = kTRUE );
  void SetTimeFitValid       ( const Bool_t b = kTRUE );
  void SetFluxOutsidePlexiglassAvailable ( const Bool_t b = kTRUE );

  // Setters ONLY for MC:
  void  SetMeanTimeInFirstBin( const Bool_t b = kTRUE );
  void  SetMeanTimeInLastBin ( const Bool_t b = kTRUE );

  // Getters
  Float_t GetMeanCharge()      const { return fMeanCharge;         }
  Float_t GetMeanChargeErr()   const { return fMeanChargeErr;      }
  Float_t GetSigmaCharge()     const { return fSigmaCharge;        }
  Float_t GetSigmaChargeErr()  const { return fSigmaChargeErr;     }
  Float_t GetChargeProb()      const { return fChargeProb;         }    

  Float_t GetMeanFluxOutsidePlexiglass()    const { return fMeanFluxOutsidePlexiglass; }
  Float_t GetMeanFluxErrOutsidePlexiglass() const { return fMeanFluxErrOutsidePlexiglass; }

  // Pedestals
  Float_t GetPed()             const { return fPed;    }
  Float_t GetPedRms()          const { return fPedRms; }


  Bool_t  IsExcluded()          const;
  Bool_t  IsChargeFitValid()    const;
  Bool_t  IsTimeFitValid()      const;

  Bool_t  IsMeanTimeInFirstBin() const;
  Bool_t  IsMeanTimeInLastBin()  const;

  Bool_t  CheckChargeFitValidity();
  Bool_t  CheckTimeFitValidity();
  Bool_t  CalcFluxOutsidePlexiglass();

  ClassDef(MCalibrationChargePINDiode, 1)	// Container for Calibration PIN Diode
};

#endif   /* MARS_MCalibrationChargePINDiode */









