#ifndef MARS_MHCalibrationChargeHiGainPix
#define MARS_MHCalibrationChargeHiGainPix


#ifndef MARS_MHCalibrationChargePix
#include "MHCalibrationChargePix.h"
#endif

class TH1F;
class MHCalibrationChargeHiGainPix : public MHCalibrationChargePix
{
private:

  static const Int_t   fgChargeNbins;     // Default for fChargeNBins  (now set to: 2000  )
  static const Axis_t  fgChargeFirst;     // Default for fChargeFirst  (now set to: -0.5  )
  static const Axis_t  fgChargeLast;      // Default for fChargeLast   (now set to: 1999.5)
  static const Int_t   fgAbsTimeNbins;    // Default for fAbsTimeNbins (now set to: 20    )
  static const Axis_t  fgAbsTimeFirst;    // Default for fAbsTimeFirst (now set to: -0.5  )
  static const Axis_t  fgAbsTimeLast;     // Default for fAbsTimeLast  (now set to: 19.5  )

public:

  MHCalibrationChargeHiGainPix(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargeHiGainPix(){}

  // Setters
  void SetChargeNbins(const Int_t  bins =fgChargeNbins)          { fChargeNbins = bins;     }
  void SetChargeFirst(const Axis_t first=fgChargeFirst)          { fChargeFirst = first;    }
  void SetChargeLast (const Axis_t last =fgChargeLast)           { fChargeLast  = last;     }
  
  void SetAbsTimeNbins(const Int_t  bins =fgAbsTimeNbins)        { fAbsTimeNbins = bins;    }
  void SetAbsTimeFirst(const Axis_t first=fgAbsTimeFirst)        { fAbsTimeFirst = first;   }
  void SetAbsTimeLast (const Axis_t last =fgAbsTimeLast)         { fAbsTimeLast  = last;    }

  ClassDef(MHCalibrationChargeHiGainPix, 1)  // Histogram class for High Gain part of Calibration Pixel 
};

#endif






