#ifndef MARS_MHCalibrationChargeCam
#define MARS_MHCalibrationChargeCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

class MRawEvtData;
class MBadPixelsPix;
class MCalibrationChargeCam;
class MCalibrationChargePix;
class MHCalibrationChargePix;
class MHCalibrationChargeCam : public MHCalibrationCam
{
private:

  static const Float_t fgNumHiGainSaturationLimit;   // The default for fNumHiGainSaturationLimit
  static const Float_t fgNumLoGainSaturationLimit;   // The default for fNumLoGainSaturationLimit
  
  Float_t fNumHiGainSaturationLimit;  // Rel. amount sat. higain FADC slices until pixel is called saturated
  Float_t fNumLoGainSaturationLimit;  // Rel. amount sat. logain FADC slices until pixel is called saturated
  
  MRawEvtData *fRawEvt;               //!  Raw event data 

  Bool_t SetupHists(const MParList *pList);
  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);
  Bool_t FinalizeHists();
  void   FinalizeBadPixels();

  void FinalizeHiGainHists(MHCalibrationChargePix &hist, MCalibrationChargePix &pix, MBadPixelsPix &bad);
  void FinalizeLoGainHists(MHCalibrationChargePix &hist, MCalibrationChargePix &pix, MBadPixelsPix &bad);

 public:

  MHCalibrationChargeCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargeCam() {}
  
  void SetNumLoGainSaturationLimit( const Float_t lim=fgNumLoGainSaturationLimit) { fNumLoGainSaturationLimit = lim; }
  void SetNumHiGainSaturationLimit( const Float_t lim=fgNumHiGainSaturationLimit) { fNumHiGainSaturationLimit = lim; }
  
  Float_t GetNumHiGainSaturationLimit()      const  { return fNumHiGainSaturationLimit; }
  Float_t GetNumLoGainSaturationLimit()      const  { return fNumLoGainSaturationLimit; }

  Bool_t GetPixelContent ( Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void   DrawPixelContent( Int_t num )  const;    

  ClassDef(MHCalibrationChargeCam, 1)	// Histogram class for Charge Camera Calibration 
};

#endif









