/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug   02/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
\* ======================================================================== */
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrationRelTimePix                                                  //
//                                                                         //
// Storage container to hold informations about the calibrated arrival time// 
// value of one Pixel (PMT).                                               //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MCalibrationRelTimePix.h"

ClassImp(MCalibrationRelTimePix);

using namespace std;
// --------------------------------------------------------------------------
//
// Default Constructor: 
//
MCalibrationRelTimePix::MCalibrationRelTimePix(const char *name, const char *title)
    : fRelTimeFlags(0)
{

  fName  = name  ? name  : "MCalibrationRelTimePix";
  fTitle = title ? title : "Container of the fit results of MHCalibrationRelTimePixs ";

  Clear();

}

// ------------------------------------------------------------------------
//
// Invalidate values
//
void MCalibrationRelTimePix::Clear(Option_t *o)
{

  SetValid     ( kFALSE );

  fMeanConversion   =  -1.;
  fConversionVar    =  -1.;
  fSigmaConversion  =  -1.;

  MCalibrationPix::Clear();
}


// --------------------------------------------------------------------------
//
// Set the conversion factors from outside (only for MC)
//
void MCalibrationRelTimePix::SetConversion(Float_t c, Float_t err, Float_t sig)
{
  fMeanConversion  = c;
  fConversionVar   = err*err;
  fSigmaConversion = sig;
}


// --------------------------------------------------------------------------
//
// Set the Excluded Bit from outside 
//
void MCalibrationRelTimePix::SetValid(const Bool_t b )
{ 
  b ?  SETBIT(fRelTimeFlags, kValid) : CLRBIT(fRelTimeFlags, kValid); 
}    


Float_t MCalibrationRelTimePix::GetConversionErr()  const
{
  if (fConversionVar < 0.)
    return -1.;
  return TMath::Sqrt(fConversionVar);
}


Bool_t MCalibrationRelTimePix::IsValid() const 
{ 
  return TESTBIT(fRelTimeFlags, kValid); 
}
