#ifndef MARS_MCalibrationRelTimePix
#define MARS_MCalibrationRelTimePix

#ifndef MARS_MCalibrationPix
#include "MCalibrationPix.h"
#endif

class MCalibrationRelTimePix : public MCalibrationPix
{
private:

  Float_t fMeanConversion;     // The conversion factor to Phe's (F-factor method)
  Float_t fConversionVar;      // The error of the conversion factor to Phe's (F-factor method)
  Float_t fSigmaConversion;    // The sigma of conversion factor to Phe's (F-factor method)

  Byte_t fRelTimeFlags;        // The bit-field for the class-own bits

  enum  { kValid };             // The possible bits to be set

public:

  MCalibrationRelTimePix(const char *name=NULL, const char *title=NULL);
  ~MCalibrationRelTimePix() {}
  
  void Clear(Option_t *o="");

  // Conversion Factors
  void SetConversion   ( Float_t c, Float_t err, Float_t sig );
  
  // Setters
  void SetValid( const Bool_t b = kTRUE );

  Float_t GetMeanConversion()  const  { return fMeanConversion;  }
  Float_t GetConversionErr()   const;
  Float_t GetSigmaConversion() const  { return fSigmaConversion; }

  Float_t GetTimeOffset()       const { return GetMean();        }
  Float_t GetTimeOffsetErr()    const { return GetMeanErr();     }
  Float_t GetTimePrecision()    const { return GetSigma();       }
  Float_t GetTimePrecisionErr() const { return GetSigmaErr();    }

  Bool_t IsValid()              const;

  ClassDef(MCalibrationRelTimePix, 1)	// Container for Calibration of one pixel
};

#endif

