#ifndef MARS_MWeight
#define MARS_MWeight

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  MWeight                                                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MWeight : public MParContainer
{
private:
    Double_t fWeight;

public:
    MWeight(const char *name=NULL, const char *title=NULL) : fWeight(1)
    {
        fName  = name  ? name  : "MWeight";
        fTitle = title ? title : "A weight for filling histograms";
    }

    void SetWeight(Double_t weight) { fWeight = weight; }
    Double_t GetWeight() const { return fWeight; }

    ClassDef(MWeight, 1) // A weight for filling histograms
};

#endif
