#ifndef MARS_MBadPixelsCalc
#define MARS_MBadPixelsCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MBadPixelsCam;
class MSigmabar;
class MGeomCam;
class MPedPhotCam;

class MBadPixelsCalc : public MTask
{
private:
    MGeomCam      *fGeomCam;    //! Input container storing the pixel sizes
    MSigmabar     *fSigmabar;   //! Input container storing mean pedestal rms of the camera
    MPedPhotCam   *fPedPhotCam; //! Input container storing the pedestal and pedestal rms of all pixels

    MBadPixelsCam *fBadPixels;  //! Output container holding the bad pixels

    Float_t fPedestalLevel;

    void CheckPedestalRMS() const;
    Bool_t CheckPedestalRms() const;

    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MBadPixelsCalc(const char *name=NULL, const char *title=NULL);

    void SetPedestalLevel(Float_t f) { fPedestalLevel=f; }

    ClassDef(MBadPixelsCalc, 1) // Task to find bad pixels (star, broken pixels, etc)
}; 

#endif




