#ifndef MARS_MHCalibrationChargeCam
#define MARS_MHCalibrationChargeCam

#ifndef MARS_MHCalibrationCam
#include "MHCalibrationCam.h"
#endif

class MRawEvtData;
class MExtractedSignalCam;
class MCalibrationChargePix;
class MHCalibrationChargePix;
class MHCalibrationChargeCam : public MHCalibrationCam
{
private:

  static const Float_t fgNumHiGainSaturationLimit;   //! The default for fNumHiGainSaturationLimit (now at: 0.01)
  static const Float_t fgNumLoGainSaturationLimit;   //! The default for fNumLoGainSaturationLimit (now at: 0.005)
  static const Float_t fgTimeLowerLimit;             //! Default for fTimeLowerLimit    (now set to: 1.) 
  static const Float_t fgTimeUpperLimit;             //! Default for fTimeUpperLimit    (now set to: 2.)
  
  Float_t fNumHiGainSaturationLimit;  // Rel. amount sat. higain FADC slices until pixel is called saturated
  Float_t fNumLoGainSaturationLimit;  // Rel. amount sat. logain FADC slices until pixel is called saturated
  Float_t fTimeLowerLimit;            // Limit dist. to first signal slice (in units of FADC slices) 
  Float_t fTimeUpperLimit;            // Limit dist. to last signal slice  (in units of FADC slices) 

  MRawEvtData         *fRawEvt;       //!  Raw event data 
  MExtractedSignalCam *fSig;          //!  Signal Extractor

  Bool_t SetupHists(const MParList *pList);
  Bool_t ReInitHists(MParList *pList);
  Bool_t FillHists(const MParContainer *par, const Stat_t w=1);

  void   FinalizeAbsTimes (MHCalibrationChargePix &hist, MCalibrationChargePix &pix, MBadPixelsPix &bad,
                           Byte_t first, Byte_t last);  
  Bool_t FinalizeHists();
  void   FinalizeBadPixels();


 public:

  MHCalibrationChargeCam(const char *name=NULL, const char *title=NULL);
  ~MHCalibrationChargeCam() {}
  
  void SetNumLoGainSaturationLimit( const Float_t lim=fgNumLoGainSaturationLimit) { fNumLoGainSaturationLimit = lim; }
  void SetNumHiGainSaturationLimit( const Float_t lim=fgNumHiGainSaturationLimit) { fNumHiGainSaturationLimit = lim; }
  void SetTimeLowerLimit    ( const Float_t f=fgTimeLowerLimit         ) { fTimeLowerLimit    = f;   }
  void SetTimeUpperLimit    ( const Float_t f=fgTimeUpperLimit         ) { fTimeUpperLimit    = f;   }
  
  Float_t GetNumHiGainSaturationLimit()      const  { return fNumHiGainSaturationLimit; }
  Float_t GetNumLoGainSaturationLimit()      const  { return fNumLoGainSaturationLimit; }

  Bool_t GetPixelContent ( Double_t &val, Int_t idx, const MGeomCam &cam, Int_t type=0) const;
  void   DrawPixelContent( Int_t num )  const;    

  ClassDef(MHCalibrationChargeCam, 1)	// Histogram class for Charge Camera Calibration 
};

#endif









