#include "MCeCoCom.h"

#include <iostream>

using namespace std;

bool MCeCoCom::InterpreteCmd(TString cmd, TString str)
{
    cout << cmd << ": " << str << endl;
    return true;
}

bool MCeCoCom::InterpreteReport(TString &str)
{
    int y, m, d, h, min, s, ms, len;

    int n=sscanf(str.Data(),
                 "%02d %04d %02d %02d %02d %02d %02d %03d %n",
                 &fCCStatus, &y, &m, &d, &h, &min, &s, &ms, &len);
    if (n!=8)
    {
        cout << "Communication Problem: Wrong number of arguments" << endl;
        fComStat = kComProblem;
        return false;
    }
    str.Remove(0, len);

    fT.Set(y, m, d, h, min, s, ms);

    // Remove the 30 tokens of the subsystem status
    //  table 12.1 p59
    for (int i=0; i<30; i++)
        str.Remove(0, str.First(' ')+1);

    // skip solar_irr_Wm2, wind_speed, UPS
    float zd, az, dec, ra, temp, solar, wind, hum;
    n=sscanf(str.Data(),
             "%f %f %f %f %f %f %f %f %*f %*f %n",
             &zd, &az, &dec, &ra, &temp, &solar, &wind, &hum, &len);
    if (n!=8)
    {
        cout << "Communication Problem: Wrong number of arguments" << endl;
        fComStat = kComProblem;
        return false;
    }
    str.Remove(0, len);

    if (str!=(TString)"OVER")
    {
        cout << "Communication Problem: Termination (OVER) too far away." << endl;
        fComStat = kComProblem;
        return false;
    }

    cout << "Zd/Az: " << zd << "/" << az << "   ";
    cout << "Ra/Dec: " << ra << "/" << dec << "   ";
    cout << "Temp: " << temp << "'C   ";
    cout << "Hum: " << hum << "%   ";
    cout << "SolRad: " << solar << "W/m   ";
    cout << "Wind: " << wind << "km/h" << endl;

    fHumidity = hum;
    fTemperature = temp;
    fSolarRadiation = solar;
    fWindSpeed = wind;

    fComStat = kCmdReceived;
    return true;
}

bool MCeCoCom::InterpreteStr(TString str)
{
    const Ssiz_t tok  = str.First(' ');
    const TString cmd = tok<0 ? str : str(0, tok);
    if (tok<0)
        str = "";
    else
        str.Remove(0, tok+1);

    if (cmd==(TString)"CC-REPORT" && str.EndsWith("OVER"))
        return InterpreteReport(str);

    const bool rc = InterpreteCmd(cmd, str.Strip(TString::kBoth));
    fComStat = rc ? kCmdReceived : kComProblem;
    return rc;
}

bool MCeCoCom::Send(const char *str)
{
    MTime t;
    t.Now();

    UShort_t y1, y2, ms1, ms2;
    Byte_t mon1, mon2, d1, d2, h1, h2, m1, m2, s1, s2;

    t.GetDate(y1, mon1, d1);
    t.GetTime(h1, m1, s1, ms1);

    fT.GetDate(y2, mon2, d2);
    fT.GetTime(h2, m2, s2, ms2);

    const char *msg =
        Form("%s "
             "%02d %04d %02d %02d %02d %02d %02d %03d "
             "%02d %04d %02d %02d %02d %02d %02d %03d "
             "%s\n", (const char*)fCommand,
             fStatus,  y1, mon1, d1, h1, m1, s1, ms1,
             fComStat, y2, mon2, d2, h2, m2, s2, ms2,
             str);

    const bool rc = MTcpIpIO::Send(msg);
    fComStat = rc ? kNoCmdReceived : kComProblem;
    return rc;
}
