/***************************************************************************
                          calibratepaneldialog.h  -  description
                             -------------------
    begin                : Tue Sep 2 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CALIBRATEPANELDIALOG_H
#define CALIBRATEPANELDIALOG_H

#include <qlist.h>
#include <qstring.h>
#include <qthread.h>
#include <qwidget.h>
#include <calibratepaneldialogbase.h>

/**
  *@author Martin Merck
  */
class	AMCFrameGrabber;
class	AMCMirrorPanel;
class	AMCMotor;
class LinearRegression;
class	VideoFrame;
class	VideoSpot;

class CalibratePanelDialog : public CalibratePanelDialogBase, public QThread
{
   Q_OBJECT
public: 
	CalibratePanelDialog( QWidget *parent=0, const char *name=0, AMCFrameGrabber* p_pFG=0 );
	virtual ~CalibratePanelDialog();
  /** Handle events from the spot finder thread. */
	virtual void setPanel( AMCMirrorPanel* p_pPanel );
	virtual void setTSigmas( double p_dTSigmas );
	virtual void customEvent( QCustomEvent* e );
	virtual void run();
	virtual QList<VideoSpot>* getLineList() { return &m_qlLineList;};
	virtual LinearRegression* getXRegression() { return m_pXLinearRegression; };
	virtual LinearRegression* getYRegression() { return m_pYLinearRegression; };
  /** No descriptions */
  void gotoPosition( int p_iX, int p_iY );

private: // Private utility methods
	/** Output progress information to QMultiLineEdit widget */
	void outputProgress( QString p_qsMsg );
	/** Output error information to QMultiLineEdit widget */
	void outputError( QString p_qsMsg );
	/** Process Spot */
	void processSpot( int p_iX, int p_iY );
	/** Substract dark frame */
	void subtractDark();
	/** Find the Spot in the cideo frame */
	void findSpot( int& p_iY, int& p_iY );
	/** Get the threshold for identifying the spot */
	int getThreshold();

private: // Private attributes
  /** No descriptions */
  AMCFrameGrabber*	m_pFG;
  /** No descriptions */
  VideoFrame*				m_pVideoFrame;
  /** No descriptions */
  AMCMirrorPanel*		m_pPanel;
  /** No descriptions */
	AMCMotor*					m_pMotor;
  /** No descriptions */
	LinearRegression* m_pXLinearRegression;
  /** No descriptions */
	LinearRegression* m_pYLinearRegression;
  /** No descriptions */
	QList<VideoSpot>  m_qlSpotList;
  /** No descriptions */
	QList<VideoSpot>  m_qlLineList;
	/** Array to store the grabbed videoframe */
	uchar*						m_pData;
	/** Array to store the grabbed dark frame */
	uchar*						m_pDark;
	/** Spot position in videocamera pixels */
	int m_iSpotX;
	/** Spot position in videocamera pixels */
	int m_iSpotY;
	/** Spot position in videocamera pixels */
	int m_iVSpotX;
	/** Spot position in videocamera pixels */
	int m_iVSpotY;
	/**  */
	double m_dXConversion;
	/**  */
	double m_dYConversion;
	/**  */
	double m_dTSigmas;
	bool m_zLaser;

public slots: // Public slots
  /** No descriptions */
  void setSpotInfoSlot( int p_iX, int p_iY );
  /** No descriptions */
  void setGRefInfoSlot( int p_iX, int p_iY );
  /** No descriptions */
  void startSlot();
  /** No descriptions */
  void gotoRefSlot();
};

#endif
