/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug 02/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
//  MHCalibrationRelTimePix
//
//  Histogram class for the relative arrival time calibration. 
//  Stores and fits the relative arrival times between pixel fPixId and 
//  pixel number 1 (hardware index: 2). Times are taken from MArrivalTimePix
//
//  Results are re-normalized to a value per time (ns) with the formulae:
//
// - Mean Rel. Time         = Mean Rel. Time        * fFADCSliceWidth
// - Mean Rel. Time Error   = Mean Rel. Time Error  * fFADCSliceWidth
// - Sigma Rel. Time        = Sigma Rel. Time       * fFADCSliceWidth
// - Sigma Rel. Time Error  = Sigma Rel. Time Error * fFADCSliceWidth
// 
//////////////////////////////////////////////////////////////////////////////
#include "MHCalibrationRelTimePix.h"

#include <TH1.h>

ClassImp(MHCalibrationRelTimePix);

using namespace std;
//
const Int_t   MHCalibrationRelTimePix::fgRelTimeNbins    = 900;
const Axis_t  MHCalibrationRelTimePix::fgRelTimeFirst    = -13.;
const Axis_t  MHCalibrationRelTimePix::fgRelTimeLast     =  13.;
const Float_t MHCalibrationRelTimePix::fgFADCSliceWidth  =  3.3333;
// --------------------------------------------------------------------------
//
// Default Constructor. 
//
// Sets: 
// - the default number for fNbins  (fgRelTimeNbins)
// - the default number for fFirst  (fgRelTimeFirst)
// - the default number for fLast   (fgRelTimeLast)
//
// - the default name of the  fHGausHist ("HCalibrationRelTime")
// - the default title of the fHGausHist ("Distribution of Relative Arrival Times Pixel ")
// - the default x-axis title for fHGausHist ("FADC Slice")
// - the default y-axis title for fHGausHist ("Nr. of events")
// 
// - the default number for fFADCSliceWidth (fgFADCSliceWidth)
//
MHCalibrationRelTimePix::MHCalibrationRelTimePix(const char *name, const char *title) 
{ 

  fName  = name  ? name  : "MHCalibrationRelTimePix";
  fTitle = title ? title : "Histogrammed Calibration Relative Arrival Time events";

  SetNbins ( fgRelTimeNbins );
  SetFirst ( fgRelTimeFirst );
  SetLast  ( fgRelTimeLast  );
  SetFADCSliceWidth();

  // Create a large number of bins, later we will rebin
  fHGausHist.SetName("HCalibrationRelTime");
  fHGausHist.SetTitle("Distribution of Relative Arrival Times Pixel ");
  fHGausHist.SetXTitle("FADC Slice");
  fHGausHist.SetYTitle("Nr. of events");

}


// --------------------------------------------------------------------------
//
// Empty function to overload MHGausEvents::Reset()
//
void MHCalibrationRelTimePix::Reset()
{
}

// --------------------------------------------------------------------------
// 
// If mean and sigma have not yet been set, returns.
//
// HAS BEEN COMMENTED IN ORDER TO ALLOW FURTHER CALIBRATION OF OFFSETS IN DATA
// RETURNS ALWAYS WITHOUT RENORMALIZING!!
// Results are re-normalized to a value per time (ns) with the formulae:
//
// - Mean Rel. Time         = Mean Rel. Time        * fFADCSliceWidth
// - Mean Rel. Time Error   = Mean Rel. Time Error  * fFADCSliceWidth
// - Sigma Rel. Time        = Sigma Rel. Time       * fFADCSliceWidth
// - Sigma Rel. Time Error  = Sigma Rel. Time Error * fFADCSliceWidth
// 
void MHCalibrationRelTimePix::Renorm()
{

  /*
  if (fMean == fMeanErr == fSigma == fSigmaErr == 0.)
    return;

  fMean    *= fFADCSliceWidth;
  fMeanErr *= fFADCSliceWidth;
  fSigma   *= fFADCSliceWidth;
  fSigmaErr*= fFADCSliceWidth;
  */
}
