#ifndef MARS_MCalibrationRelTimeCalc
#define MARS_MCalibrationRelTimeCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCalibrationRelTimeCalc                                                   //
//                                                                         //
// Integrates the time slices of the all pixels of a calibration event     //
// and substract the pedestal value                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MBadPixelsPix
#include "MBadPixelsPix.h"
#endif

#ifndef MARS_MCalibrationRelTimeCam
#include "MCalibrationRelTimeCam.h"
#endif

class MCalibrationRelTimePix;
class MCalibrationRelTimeCam;
class MGeomCam;
class MBadPixelsCam;
class MBadPixelsPix;
class MCalibrationRelTimeCalc : public MTask
{
private:

  static const Float_t fgRelTimeRelErrLimit;      //! Default for fRelTimeRelErrLimit      (now set to: 1.)
 
  // Variables
  Float_t fRelTimeRelErrLimit;                  // Limit acceptance rel. error mean (in abs. numbers)
  Byte_t  fFlags;                              // Bit-field for the flags

  // Pointers
  MBadPixelsCam              *fBadPixels;      //  Bad Pixels 
  MCalibrationRelTimeCam     *fCam;            //  Calibrated RelTimes of all pixels 
  MGeomCam                   *fGeom;           //! Camera geometry

  // enums
  enum  { kHiLoGainCalibration };

  // functions
  Bool_t FinalizeRelTimes        ( MCalibrationRelTimePix &cal, MBadPixelsPix &bad      );
  void   FinalizeBadPixels      ();
  void   FinalizeUnsuitablePixels();

  void   PrintUncalibrated( MBadPixelsPix::UncalibratedType_t typ, const char *text) const;

  Int_t  PreProcess (MParList *pList);
  Bool_t ReInit     (MParList *pList); 
  Int_t  Process    ();
  Int_t  PostProcess();

public:

  MCalibrationRelTimeCalc(const char *name=NULL, const char *title=NULL);

  void Clear(const Option_t *o="");
  
  void SetRelTimeRelErrLimit ( const Float_t f=fgRelTimeRelErrLimit      ) { fRelTimeRelErrLimit = f;   }

  void SkipHiLoGainCalibration ( const Bool_t b=kTRUE )
      { b ? CLRBIT(fFlags, kHiLoGainCalibration) : SETBIT(fFlags, kHiLoGainCalibration); }

  ClassDef(MCalibrationRelTimeCalc, 1)   // Task finalizing the relative time Calibration 
};

#endif
