#ifndef COSY_Rings
#define COSY_Rings

#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif

#ifndef COSY_Ring
#include "Ring.h"
#endif

class Leds;

class Rings : public TClonesArray
{
private:
    Ring fCenter;

    void CalcCenters(const Leds &leds, Float_t min, Float_t max);

public:
    Rings() : TClonesArray("Ring", 1) {}

    void CalcRings(Leds &leds, Float_t min=-1, Float_t max=-1);

    void Print(Option_t *o=NULL) const;

    const Ring &operator()(int i) const { return *(Ring*)At(i); }
    Ring &operator()(int i) { return *(Ring*)At(i); }

    const Ring &GetCenter() const { return fCenter; }

    ClassDef(Rings, 1)
};

#endif
