/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 12/2000 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */


void collarea(TString filename="camera.root", TString outname="")
{
    MStatusDisplay *d = new MStatusDisplay;
    // redirect logging output to GUI, kFALSE to disable stream to stdout
    d->SetLogStream(&gLog, kTRUE);

    //
    // first we have to create our empty lists
    //
    MParList  parlist;
    MTaskList tasklist;

    parlist.AddToList(&tasklist);

    //
    // Setup out tasks:
    //  - First we have to read the events
    //  - Then we can fill the efficiency histograms
    //
    MReadMarsFile reader("Events", filename);
    MMcCollectionAreaCalc effi;

    tasklist.AddToList(&reader);
    tasklist.AddToList(&effi);

    //
    // set up the loop for the processing
    //
    MEvtLoop magic;
    magic.SetParList(&parlist);

    //
    // Start to loop over all events
    //
    magic.SetDisplay(d);
    if (!magic.Eventloop())
        return;

    tasklist.PrintStatistics();

    //
    // Now the histogram we wanted to get out of the data is
    // filled and can be displayed
    //
    if ((d = magic.GetDisplay()))
        d->AddTab("Collection Area");
    else
        new TCanvas("CollArea", "Result of the collection area calculation");

    parlist.FindObject("MHMcCollectionArea")->DrawClone("nonew");


    //
    // Write histogram to a file in case an output
    // filename has been supplied
    //
    if (outname.IsNull())
        return;

    TFile f(outname, "recreate");
    if (!f)
        return;

    parlist.FindObject("MHMcCollectionArea")->Write();
}
