#ifndef MARS_MHMcCollectionArea
#define MARS_MHMcCollectionArea

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1D;
class TH2D;

class MHMcEfficiency;
class MHMcEnergyImpact;

class MHMcCollectionArea : public MH
{
private:
    TH2D *fHistAll; //! all simulated showers
    TH2D *fHistSel; //! the selected showers

    TH1D *fHistCol; //  the collection area

    Float_t fMCAreaRadius; // [m] Radius of circle within which the cores 
                           // of Corsika events have been uniformly 
                           // distributed.

    void Calc(TH2D &hsel, TH2D &hall);

public:
    MHMcCollectionArea(const char *name=NULL, const char *title=NULL);
    ~MHMcCollectionArea();

    void FillAll(Double_t energy, Double_t radius);
    void FillSel(Double_t energy, Double_t radius);

    void DrawAll(Option_t *option="");
    void DrawSel(Option_t *option="");

    const TH1D *GetHist()       { return fHistCol; }
    const TH1D *GetHist() const { return fHistCol; }

    TH2D *GetHistAll()    { return fHistAll; }

    void Draw(Option_t *option="");

    void CalcEfficiency();
    void CalcEfficiency2();

    void Calc(const MHMcEnergyImpact &mcsel, const MHMcEnergyImpact &mcall);
    void Calc(const MHMcEfficiency &heff);

    void SetMCAreaRadius(Float_t x) { fMCAreaRadius = x; } 

    ClassDef(MHMcCollectionArea, 1)  // Data Container to calculate Collection Area
};

#endif
