/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug  02/2004 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MExtractedSignalBlindPixel
//
// This is the storage container to hold informations about the extracted signal 
// (offset) value of the calibration PIN Diode
//
/////////////////////////////////////////////////////////////////////////////
#include "MExtractedSignalBlindPixel.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MExtractedSignalBlindPixel);

using namespace std;

static const UInt_t gkSignalInitializer = 99999;

// ------------------------------------------------------------------------
//
// MExtractedSignalBlindPixel holds the extracted signal
// of the FADC slices and its error. 
//
// Additionally, the number of saturated Slices are stored. 
// 
// Default values for the extracted signals are: 99999.9 
//
MExtractedSignalBlindPixel::MExtractedSignalBlindPixel(const char* name, const char* title)
{

  fName  = name  ? name  : "MExtractedSignalBlindPixel";
  fTitle = title ? title : "Container of the Extracted Signals";

  Clear();
}

// ------------------------------------------------------------------------
//
// Invalidate values
//
void MExtractedSignalBlindPixel::Clear(Option_t *o)
{

  fExtractedSignal    = gkSignalInitializer;

  fPed                = gkSignalInitializer;;      
  fPedErr             = gkSignalInitializer;;   
  fPedRms             = gkSignalInitializer;;   
  fPedRmsErr          = gkSignalInitializer;;  
  
  fNumSaturated       = 0;
}

void MExtractedSignalBlindPixel::SetUsedFADCSlices(const Byte_t first, const Byte_t num)   
{
  fFirst          = first; 
  fNumFADCSamples = num;
}


Bool_t MExtractedSignalBlindPixel::IsValid() const
{
    return fExtractedSignal >= 0 && fExtractedSignal <  gkSignalInitializer;
}

void MExtractedSignalBlindPixel::Print(Option_t *o) const
{
  *fLog << " Signal: " << fExtractedSignal
        << " Nr. Saturation: " <<  fNumSaturated
        << endl;
}
