#ifndef MARS_MStarLocalPos
#define MARS_MStarLocalPos

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MStarLocalPos : public MParContainer
{
private:

    //Expected position on camera
    
    Float_t fMagExp;
    Float_t fXExp;    //[mm]
    Float_t fYExp;    //[mm]

    //Info from calculation

    Float_t fMagCalc;
    Float_t fMeanXCalc;          //[mm]
    Float_t fMeanYCalc;          //[mm]
    Float_t fSigmaMinorAxisCalc; //[mm]
    Float_t fSigmaMajorAxisCalc; //[mm]

    //Info from fit

    Float_t fMagFit;
    Float_t fMeanXFit;           //[mm]
    Float_t fMeanYFit;           //[mm]
    Float_t fSigmaMinorAxisFit;  //[mm]
    Float_t fSigmaMajorAxisFit;  //[mm]
    Float_t fChisquarenDof;

public:

    MStarLocalPos(const char *name=NULL, const char *title=NULL);
    //~MStarLocalPos();

    Float_t GetMagExp() {return fMagExp;}
    Float_t GetXExp() {return fXExp;}
    Float_t GetYExp() {return fYExp;}

    Float_t GetMagCalc() {return fMagCalc;}
    Float_t GetMeanXCalc() {return fMeanXCalc;}
    Float_t GetMeanYCalc() {return fMeanYCalc;}
    Float_t GetSigmaMinorAxisCalc() {return fSigmaMinorAxisCalc;}
    Float_t GetSigmaMajorAxisCalc() {return fSigmaMajorAxisCalc;}

    Float_t GetMagFit() {return fMagFit;}
    Float_t GetMeanXFit() {return fMeanXFit;}
    Float_t GetMeanYFit() {return fMeanYFit;}
    Float_t GetSigmaMinorAxisFit() {return fSigmaMinorAxisFit;}
    Float_t GetSigmaMajorAxisFit() {return fSigmaMajorAxisFit;}
    Float_t GetChisquarenDof() {return fChisquarenDof;}

    void Reset();

    void SetExpValues(Float_t mag, Float_t x, Float_t y);
    void SetCalcValues(Float_t mag, Float_t x, Float_t y, Float_t sigmaMinorAxis, Float_t sigmaMajorAxis);
    void SetFitValues(Float_t mag, Float_t x, Float_t y, Float_t sigmaMinorAxis, Float_t sigmaMajorAxis);

    void Paint(Option_t *opt=NULL);
    void Print(Option_t *opt=NULL) const;

    ClassDef(MStarLocalPos, 1) // Container that holds 
};

#endif
