#ifndef MARS_MIslands
#define MARS_MIslands

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif


class MIslands : public MParContainer
{
private:
    // for description see MIslands.cc
    Int_t fIslNum;                 //  number of islands
    Int_t fIslId[577];             //  island Id
    Int_t fPixNum[20];             //  number of pixels in the island
    Float_t fSigToNoise[20];       //  signal to noise of the island
    Float_t fTime[20][577];        //  mean of the arrival time  
    // Float_t fTimeHi[20][577];      //  mean of the arrival time in the hi gain 
    // Float_t fTimeLo[20][577];      //  mean of the arrival time in the lo gain
    Float_t fTimeSpread[20];       //  mean arrival time spread of the island  
    //  Float_t fTimeSpreadHi[20];     //  mean arrival time spread of the island  
    // Float_t fTimeSpreadLo[20];     //  mean arrival time spread of the island  

public:
    MIslands(const char *name=NULL, const char *title=NULL);
    ~MIslands();

    Int_t    GetIslNum() const                        { return fIslNum; } 
    Int_t    GetIslId(Int_t idx) const                { return fIslId[idx]; }
    Int_t    GetPixNum(Int_t isl)                     { return fPixNum[isl]; }
    Float_t  GetSigToNoise(Int_t isl)                 { return fSigToNoise[isl]; }
    Float_t  GetArrivalTime(Int_t isl, Int_t idx) { return fTime[isl][idx]; }           
    //Float_t  GetArrivalTimeHiGain(Int_t isl, Int_t idx) { return fTimeHi[isl][idx]; }           
    //Float_t  GetArrivalTimeLoGain(Int_t isl, Int_t idx) { return fTimeLo[isl][idx]; } 
    Float_t  GetTimeSpread(Int_t isl) { return fTimeSpread[isl];}          
    //Float_t  GetTimeSpreadHi(Int_t isl) { return fTimeSpreadHi[isl];}
    //Float_t  GetTimeSpreadLo(Int_t isl) { return fTimeSpreadLo[isl];}

    void     SetIslNum(Int_t nisl)                    { fIslNum = nisl; }
    void     SetIslId(Int_t idx, Int_t isl)           { fIslId[idx] = isl; }
    void     SetPixNum(Int_t isl, Int_t npix)         { fPixNum[isl] = npix; }
    void     SetSigToNoise(Int_t isl, Float_t val)    { fSigToNoise[isl] = val; }
    void     SetArrivalTime(Int_t isl, Int_t idx, Float_t val)   { fTime[isl][idx] = val;}
    // void     SetArrivalTimeHiGain(Int_t isl, Int_t idx, Float_t val)   { fTimeHi[isl][idx] = val;}
    //void     SetArrivalTimeLoGain(Int_t isl, Int_t idx, Float_t val)   { fTimeLo[isl][idx] = val;}
    void     SetTimeSpread(Int_t isl, Float_t val) { fTimeSpread[isl] = val; }
    //void     SetTimeSpreadHi(Int_t isl, Float_t val) { fTimeSpreadHi[isl] = val; }
    //void     SetTimeSpreadLo(Int_t isl, Float_t val) { fTimeSpreadLo[isl] = val; }
    
    ClassDef(MIslands, 1) // Storage Container for Island Parameters
};

#endif
