#ifndef MARS_MSrcPosFromFile
#define MARS_MSrcPosFromFile

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TMap
#include <TExMap.h>
#endif

class TH2F;

class MRawRunHeader;
class MSrcPosCam;

class MSrcPosFromFile : public MTask
{
 private:

    MRawRunHeader *fRawRunHeader;
    MSrcPosCam    *fSrcPos;   //  Pointer to the source position

    Int_t  fNumRuns;
    UInt_t  fLastRun;

    Int_t      *fRunList;
    MSrcPosCam *fRunSrcPos;
    TExMap     *fRunMap;   // list of run numbers positions

    TH2F    *fHistSrcPos;
    UShort_t fMode;

    TString fSourcePositionFilePath;
    Int_t ReadSourcePositionsFile(UShort_t readmode);

    Int_t PreProcess(MParList *plist);
    Bool_t ReInit(MParList *plist);
    Int_t Process();
    Int_t PostProcess();

public:
    
    enum ReadMode_t {kCount=0,kRead};
    enum OnOffMode_t {kOn=0,kOff};

    MSrcPosFromFile(TString cardpath, OnOffMode_t mode=kOn, const char *name=NULL, const char *title=NULL);
    ~MSrcPosFromFile();
    
    void SetMode(OnOffMode_t mode) {fMode=mode;}

    ClassDef(MSrcPosFromFile, 0) // task to calculate the position of the source as a function of the run number 
};

#endif
