#ifndef MARS_MSrcTranslate
#define MARS_MSrcTranslate

#ifndef MARS_MTask
#include "MTask.h"
#endif

#include <TArrayF.h>
#include "MTime.h"
#include "MSrcPosCam.h"

class MDCA;
class MObservatory;
class MRawEvtHeader;
class MRawRunHeader;

class MSrcTranslate : public MTask
{
private:
    MSrcPosCam*    fSrcPos;      //!  Pointer to the source position
    MDCA*          fDCA;         //!  Pointer to the MDCA object

    TString     fSrcPosName;
    TString     fDCAName;

    Double_t fShiftX;
    Double_t fShiftY;
    Bool_t   fTranslationIsRelative;

    Int_t PreProcess(MParList *plist);
    Int_t Process();

public:
    MSrcTranslate(const char* src="MSrcPosCam", const char* dca="MDCA",
	       const char* name=NULL, const char* title=NULL);

    void SetTranslation(Double_t x=0.,Double_t y=0) {fShiftX=x,fShiftY=y;};
    void SetRelativeTranslation(Bool_t inp=kTRUE) {fTranslationIsRelative=inp;};

    ClassDef(MSrcTranslate, 0) // task to rotate the position of the source as a function of Azimuth and Zenith angles
};

#endif

