#ifndef COSY_MTracking
#define COSY_MTracking

#ifndef COSY_MPointing
#include "MPointing.h"
#endif

#ifndef COSY_MThread
#include "MThread.h"
#endif

class MTracking : public MPointing, public MThread
{
private:
    Float_t fTrackAcc;
    Float_t fTrackDec;

    bool SetVelocity(const ZdAz &v);
    bool InitTracking();
    bool LimitSpeed(ZdAz *vt, const ZdAz &vcalc) const;

    void *Thread();

public:
    MTracking(MCosy *cosy, const Log &log) : MPointing(cosy, log), MThread(kFALSE), fTrackAcc(0.1), fTrackDec(0.1) { }

    void TrackPosition(const RaDec &dst); // ra, dec [rad]
    void SetTrackAccDec(Float_t acc, Float_t dec) { fTrackAcc=0.1; fTrackDec=0.1; }

    //void TalkThreadTracking();
  
    ClassDef(MTracking, 0)
};

#endif
