#ifndef MARS_MPedestalPix
#define MARS_MPedestalPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MPedestalPix : public MParContainer
{
private:

  Float_t fPedestal;     // mean value of pedestal (PMT offset)
  Float_t fPedestalRms;  // root mean square / sigma  / standard deviation of pedestal
  Bool_t  fValid;        // flag to set pixel valid
  
public:
  MPedestalPix();
  
  void Clear(Option_t *o="");
  
  // Using histograms
  void InitUseHists();
  
    // Setters
  void SetPedestal(const Float_t f)    { fPedestal = f; }
  void SetPedestalRms(const Float_t f) { fPedestalRms = f; }
  
  void Set(const Float_t m, const Float_t r);
  void SetValid(const Bool_t b=kTRUE)    { fValid = b;  }
  
  // Getters
  Float_t GetPedestal()    const { return fPedestal; }
  Float_t GetPedestalRms() const { return fPedestalRms; }
  
  Bool_t IsValid()         const;

  ClassDef(MPedestalPix, 1)	// Storage Container for Pedestal information of one pixel
};

#endif

