#ifndef COSY_MStarguider
#define COSY_MStarguider

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

#include "PixClient.h"

#ifndef MARS_MObservatory
#include "MObservatory.h"
#endif

#ifndef MARS_MTime
#include "MTime.h"
#endif

#include "MGList.h"
#include "MGImage.h"

#include "coord.h"

class TArrayF;
class TGLabel;

class TTimer;

class MGMenuBar;
class MGPopupMenu;
class TGTextEntry;

class MGImage;
class MGCoordinates;

class StarCatalog;
class MStarList;
class MCosy;
class MCaos;

class Leds;

class MStarguider : public PixClient, public TGMainFrame
{
private:
    MGList        *fList;

    MGMenuBar     *fMenu;
    MGImage       *fImage;
    MGImage       *fZoomImage;

    MGPopupMenu   *fDisplay;
    MGPopupMenu   *fWritePictures;
    MGPopupMenu   *fFileType;
    MGPopupMenu   *fWriteType;
    MGPopupMenu   *fWriteRate;
    MGPopupMenu   *fInterpol;
    MGPopupMenu   *fSetup;
    MGPopupMenu   *fLimMag;

    MGPopupMenu   *fCaosWrite;
    MGPopupMenu   *fCaosPrint;
    MGPopupMenu   *fCaosAnalyse;
    MGPopupMenu   *fCaOs;

    MGCoordinates *fCRaDec;
    MGCoordinates *fCZdAz;

    MGCoordinates *fPZdAz;

    TGTextEntry   *fPixSize;
    TGTextEntry   *fAngle;

    TGLabel       *fFps;
    TGLabel       *fPosZoom;

    StarCatalog   *fSao;
    MCosy         *fCosy;
    MCaos         *fCaos;

    RaDec *fRaDec;

    TTimer *fTimer;
    MTime   fTime;

    Int_t fDx;
    Int_t fDy;

    byte fIntRate;
    int  fWrtRate;

    void SetPixSize(const double pixsize);
    void Toggle(MGPopupMenu *p, UInt_t id);
    //void GetCoordinates();
    void CalcTrackingError(Leds &, MStarList &);
    ZdAz TrackingError(TArrayF &alt, TArrayF &az, TArrayF &mag) const;
    bool Interpolate(const unsigned long n, byte *img) const;

    //void InitHists();
    //void InitGraphs();
    void InitGui();

    //void OpenFile();

    //void ResetHists();
    //void DisplayAnalysis();
    void UpdatePosZoom();

    Bool_t HandleTimer(TTimer *t);
    //Bool_t HandleKey(Event_t* event);

public:
    MStarguider(MObservatory::LocationName_t obs);
    virtual ~MStarguider();

    //void Update();

    void Layout();
    void CloseWindow();

    Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);
    Bool_t HandleDoubleClick(Event_t *event);

    void SetPointingPosition(RaDec rd);
    void SetCosy(MCosy *c) { fCosy = c; }

    XY GetCoordinates() const;

    //
    // Execution of one frame - this function may be overloaded!
    //
    void ProcessFrame(const unsigned long n, byte *img, struct timeval *tm);

    ClassDef(MStarguider, 0)
};

#endif
