/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cherenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!   Author(s): Daniel Mazin, 05/2004 <mailto:mazin@imppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */

// Daniel Mazin 17.05.2004  mazin@mppmu.mpg.de
// **********************************************************************************
// this macro is a part from the macro falsesourcemethod.C
// This macro reads mars file with hillas parameters etc. and puts the values into vectors
// input: hillas parameter file
// output: vectors with the same information
// **********************************************************************************


void hillasfileread()
{
   lengthpar.ResizeTo(MAXNUMEVENTS);
   widthpar.ResizeTo(MAXNUMEVENTS);
   sizepar.ResizeTo(MAXNUMEVENTS);
   xpar.ResizeTo(MAXNUMEVENTS);
   ypar.ResizeTo(MAXNUMEVENTS);
   deltapar.ResizeTo(MAXNUMEVENTS);
   alphapar.ResizeTo(MAXNUMEVENTS);
   distpar.ResizeTo(MAXNUMEVENTS);
   cosgam.ResizeTo(MAXNUMEVENTS);
   singam.ResizeTo(MAXNUMEVENTS);
   conc1.ResizeTo(MAXNUMEVENTS);
   leak1.ResizeTo(MAXNUMEVENTS);

   lengthpar.Zero();
   widthpar.Zero();
   sizepar.Zero();
   xpar.Zero();
   ypar.Zero();
   deltapar.Zero();
   alphapar.Zero();
   distpar.Zero();
   cosgam.Zero();
   singam.Zero();
   conc1.Zero();
   leak1.Zero();

    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // Now setup the tasks and tasklist:
    // ---------------------------------
    //
    

    MReadMarsFile read("Events");
    read.DisableAutoScheme();

    read.AddFile(HILLASFILENAME);

    MHillas mhillas;
    plist.AddToList(&mhillas);

    MHillasSrc mhillassrc;
    plist.AddToList(&mhillassrc);

    MNewImagePar mnewimpar;
    plist.AddToList(&mnewimpar);

    MGeomCamMagic cam;
    plist.AddToList(&cam);
 
    MMcEvt mcevt;
    plist.AddToList(&mcevt); 

    MObservatory observ;
    plist.AddToList(&observ);

//    printf("observ: %f\n",observ);

    MHStarMap starmap;
//    plist.AddToList(&starmap); 
    starmap.ReInit(&plist);
//    MRawRunHeader header;
//    plist.AddToList(&header);
    
    tlist.AddToList(&read);
   
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    Float_t fMm2Deg;

cout << " file name: " << HILLASFILENAME << endl;

   if (!tlist.PreProcess(&plist))
      return;

    fMm2Deg = cam->GetConvMm2Deg();
    Int_t event = 0;
    Int_t filenumber = 0;
    Float_t theta, phi;
 
    imnum = 0;

    while (tlist.Process())
    {
    event++;
//cout << event << endl;

    if (mhillas->GetLength() != -1.)
     {


     if (ROTOPTION == kTRUE) 
     {
        theta = mcevt->GetTelescopeTheta();
        phi = mcevt->GetTelescopePhi();
//   printf("theta: %5.3f, phi: %5.3f\n", theta*180./4.1415, phi*180./4.1415);
        observ.RotationAngle(theta, phi, singam(imnum), cosgam(imnum)); 
     }

      lengthpar(imnum) = (mhillas->GetLength()) * fMm2Deg;
      widthpar(imnum) = (mhillas->GetWidth())*fMm2Deg;
      sizepar(imnum) = mhillas->GetSize();
      xpar(imnum) = (mhillas->GetMeanX())*fMm2Deg;
      ypar(imnum) = (mhillas->GetMeanY())*fMm2Deg;
      deltapar(imnum) = mhillas->GetDelta(); 
      conc1(imnum) = (mnewimpar->GetConc1());
      leak1(imnum) = mnewimpar->GetLeakage1();

      imnum++;

     }
    else filenumber++;
    }

    if (!tlist.PostProcess())
      return;

   printf("imnum = %d\n",imnum);

   lengthpar.ResizeTo(imnum);
   widthpar.ResizeTo(imnum);
   sizepar.ResizeTo(imnum);
   xpar.ResizeTo(imnum);
   ypar.ResizeTo(imnum);
   deltapar.ResizeTo(imnum);
   alphapar.ResizeTo(imnum);
   distpar.ResizeTo(imnum); 
   cosgam.ResizeTo(imnum); 
   singam.ResizeTo(imnum); 
   conc1.ResizeTo(imnum); 
   leak1.ResizeTo(imnum); 


    cout << " conversion factor is: " << fMm2Deg <<  endl;
    cout << " events read in from file : " << event <<  endl;
    cout << " runs found in the file : " << filenumber <<  endl;

}

