#ifndef COSY_MTracking
#define COSY_MTracking

#include "coord.h"

#ifndef COSY_MPointing
#include "MPointing.h"
#endif

#ifndef COSY_MThread
#include "MThread.h"
#endif

class SlaStars;

class MTracking : public MPointing, public MThread
{
private:
    Float_t fTrackAcc;
    Float_t fTrackDec;

    ZdAz    fOffset; // Offset between se and re coordinate system [re]

    MLog *fOut;

    bool RequestRePos();
    bool SetVelocity(const ZdAz &v);
    bool LimitSpeed(ZdAz *vt, const SlaStars &sla) const;
    bool InitTracking();
    //void StopTracking();

    void *Thread();

public:
    MTracking(MCosy *cosy, const Log &log) : MPointing(cosy, log), MThread(kFALSE), fTrackAcc(0.1), fTrackDec(0.1), fOut(0) { }

    void TrackPosition(const RaDec &dst); // ra, dec [rad]
    void SetTrackAccDec(Float_t acc, Float_t dec) { fTrackAcc=0.1; fTrackDec=0.1; }

    void SetOut(MLog *fout) { fOut = fout; }
    //void TalkThreadTracking();
  
    ClassDef(MTracking, 0)
};

#endif
