#ifndef MARS_MExtractTime
#define MARS_MExtractTime

#ifndef MARS_MExtractor
#include "MExtractor.h"
#endif

class MPedestalPix;
class MArrivalTimeCam;
class MExtractTime : public MExtractor
{
  
  static const Float_t fgOffsetLoGain;  // Default for fOffsetLoGain (now set to 1.51 (= 5ns)
  Float_t fOffsetLoGain;                // Offset of the low-gain signal w.r.t. the High-Gain slices 

  MArrivalTimeCam *fArrTime;   // Container with the photons arrival times
  
  virtual Int_t PreProcess(MParList *pList);
  virtual Bool_t ReInit(MParList *pList);
  virtual Int_t Process();

  virtual void FindTimeHiGain(Byte_t *firstused, Float_t &time, Float_t &dtime,
                              Byte_t &sat, const MPedestalPix &ped) const;
  virtual void FindTimeLoGain(Byte_t *firstused, Float_t &time, Float_t &dtime,
                              Byte_t &sat, const MPedestalPix &ped) const;

public:

  MExtractTime(const char *name=NULL, const char *title=NULL);

  void SetOffsetLoGain( const Float_t f=fgOffsetLoGain) { fOffsetLoGain = f; }
 
  ClassDef(MExtractTime, 0)   // Arrival Time Extractor Base Class
};

#endif



