#include "Slalib.h"

#include <time.h>
#include <iostream.h>  // cout

#include "coord.h"

#include "slalib.h"

ClassImp(Slalib);

Slalib::Slalib(MObservatory::LocationName_t key) : MObservatory(key)
{
}

Double_t Slalib::Trunc(Double_t val)
{
    /* dint(A) - truncate to nearest whole number towards zero (double) */
    return val<0 ? TMath::Ceil(val) : TMath::Floor(val);
}

Double_t Slalib::Round(Double_t val)
{
    /* dnint(A) - round to nearest whole number (double) */
    return val<0 ? TMath::Ceil(val-0.5) : TMath::Floor(val+0.5);
}

void Slalib::SetMjd(double mjd)
{
    fTime.SetMjd(mjd);

    fAlpha = slaGmst(GetMjd()) + GetElong();
}

void Slalib::Now(double offset)
{
    fTime.Now();
    SetMjd(fTime.GetMjd()+offset/(24*60*60));
}


ZdAz Slalib::XYZ2ZdAz(double coord[3]) const
{
    //
    // -- xyz to spherical coordinates --
    //
    double ra, dec;
    slaDcc2s(coord, &ra, &dec);

    //
    // radec[rad] -> hadec[rad]
    //
    const double ha = fAlpha-ra;

    //
    // hadec[rad] -> altaz[rad]
    //
    double alt, az;
    slaDe2h(ha, dec, GetPhi(), &az, &alt);

    return ZdAz(kPiDiv2-alt, az);
}
