#ifndef MARS_MChain
#define MARS_MChain

#ifndef ROOT_TChain
#include <TChain.h>
#endif

class MChain : public TChain
{
private:
    Bool_t fNotified;

public:
    MChain() : TChain(), fNotified(kFALSE) {}
    MChain(const char *name, const char *title="") : TChain(name, title), fNotified(kFALSE) {}

    void ResetTree() { fTree = 0; fTreeNumber = -1; }

    virtual Bool_t Notify() { fNotified = kTRUE; return kTRUE; }
    virtual void   SetNotify(TObject *obj) { fNotify = obj; fNotified = kFALSE; }

    Int_t LoadTree(Int_t entry);

    ClassDef(MChain, 1) // Class derived from TChain to give access to Notify-return value
};

#endif
