#ifndef MARS_MSrcRotate
#define MARS_MSrcRotate

#ifndef MARS_MSrcPlace
#include "MSrcPlace.h"
#endif

#include "MTime.h"

class MObservatory;
class MRawEvtHeader;
class MRawRunHeader;

class MSrcRotate : public MSrcPlace
{
 private:
  MRawEvtHeader* fEvtHeader;   //  Pointer to the event header
  MRawRunHeader* fRunHeader;   //  Pointer to the run header
  MObservatory*  fObservatory; //  Pointer to the MObservatory    
  
  Double_t   fRA;          //  [rad] Right ascenssion 
  Double_t   fDEC;         //  [rad] Declination
  Double_t   fRefMJD;      //  [MJ date] reference time for rotation
  UInt_t     fNEvts;       //  Number of events in file
  MTime      fIniTime;     //  Run initial time 
  MTime      fFinTime;     //  Run final time 
  Double_t   fDeltaT;      //  DeltaT between two events
  UInt_t     fRunNumber;   //  Current run number
  
  virtual Int_t PreProcess(MParList *plist);
  
 public:
  MSrcRotate(const char* srcIn="MSrcPosCam",const char* srcOut="MSrcPosCam",
	     const char* dca="MDCA",
	     const char* name=NULL, const char* title=NULL);
  
  void SetRAandDECandRefMJD(Double_t ra, Double_t dec, Double_t ref=0) {fRA=ra;fDEC=dec;fRefMJD=ref;}
  void SetRAandDEC(Double_t ra, Double_t dec){SetRAandDECandRefMJD(ra,dec);}
  virtual Int_t ComputeNewSrcPosition();
  
  ClassDef(MSrcRotate, 0) // task to rotate the position of the source as a function of Azimuth and Zenith angles
};

#endif

